unit MCIHandle;

interface

uses
  Windows, Classes, Controls, Forms, contnrs, Rubies, MPlayer;

type
  TMCIHandle = class(TObject)
  public
    { TMediaPlayer }
    procedure doNotify(Sender: TObject);
    procedure doClick(Sender: TObject; Button: TMPBtnType; var DoDefault: Boolean);
    procedure doPostClick(Sender: TObject; Button: TMPBtnType);
  end;

var
  cMediaPlayer, rb_eMCIDeviceError: Tvalue;

implementation

uses Pythia;

{ TMCIHandle }

procedure TMCIHandle.doNotify(Sender: TObject);
begin
  PhiGetHandle.doNotify(Sender, 'on_notify');
end;

procedure TMCIHandle.doClick(Sender: TObject; Button: TMPBtnType; var DoDefault: Boolean);
var
  recv, data, ret: Tvalue;
begin
  recv := TMediaPlayer(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_click'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(Ord(Button)));
  rb_ary_push(data, ap_bool(DoDefault));
  ret := PhiCallProtect(data);
  if ret <> Qnil then DoDefault := RTEST(ret);
end;

procedure TMCIHandle.doPostClick(Sender: TObject; Button: TMPBtnType);
var
  recv, data: Tvalue;
begin
  recv := TMediaPlayer(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_post_click'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(Ord(Button)));
  PhiCallProtect(data);
end;

end.
