unit HTTPHandle;

interface

uses
  Windows, Classes, Controls, Forms, contnrs, Rubies, NMFtp;

type
  THTTPHandle = class(TObject)
  public
    procedure doAboutToSend(Sender: TObject);
    procedure doAuthenticationNeeded(Sender: TObject);
    procedure doRedirect(var Handled: Boolean);
  end;

var
  eHTTPError, cHTTP: Tvalue;

implementation

uses Pythia;

procedure THTTPHandle.doAboutToSend(Sender: TObject);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_about_to_send'));
  rb_ary_push(data, recv);
  PhiCallProtect(data);
end;

procedure THTTPHandle.doAuthenticationNeeded(Sender: TObject);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_authentication_needed'));
  rb_ary_push(data, recv);
  PhiCallProtect(data);
end;

procedure THTTPHandle.doRedirect(var Handled: Boolean);
var
  recv, data: Tvalue;
  ret: Tvalue;
begin
  recv := cHTTP; // TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_redirect'));
  rb_ary_push(data, recv);
  ret := PhiCallProtect(data);
  if ret <> Qnil then Handled := RTEST(ret);
end;

end.
