unit uFountainColor;

interface

uses
  Rubies, heFountain;

var
  cFountainColor: Tvalue;

function ap_iFountainColor(real: TFountainColor; owner: Tvalue): Tvalue;
procedure Init_FountainColor;

implementation

uses
  Windows, SysUtils, Classes, Controls, Graphics,
  Pythia, uStrUtils,
  heClasses,
  uFountain,
  uEditor;

procedure FountainColor_setup(This: Tvalue; real: TFountainColor);
var
  style: TFontStyles;
begin
  rb_iv_set(This, '@bk_color', rb_int2inum(real.BkColor));
  rb_iv_set(This, '@color', rb_int2inum(real.Color));
  style := real.Style;
  rb_iv_set(This, '@style', ap_set_to_ary(style));
end;

function FountainColor_alloc(This: Tvalue; real: TFountainColor): Tvalue;
begin
  result := TmpAlloc(This, real);
  FountainColor_setup(result, real);
end;

function ap_iFountainColor(real: TFountainColor; owner: Tvalue): Tvalue;
begin
  result := FountainColor_alloc(cFountainColor, real);
  ap_owner(result, owner);
end;

function ap_iFountainColor_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iFountainColor(TFountainColor(AControl), owner)
end;
procedure Init_FountainColor;
begin
  cFountainColor := rb_define_class_under(cFountain, 'Color', ap_cObject);
  DefineProp(cFountainColor, TFountainColor);
end;

end.
