unit uEditorViewInfo;

interface

uses
  Rubies, HEditor;

var
  cEditorViewInfo: Tvalue;

function ap_iEditorViewInfo(real: TEditorViewInfo; owner: Tvalue): Tvalue;
procedure Init_EditorViewInfo;

implementation

uses
  Pythia, uEditor, uEditorFountain, uNotifyPersistent;

procedure EditorViewInfo_setup(This: Tvalue; real: TEditorViewInfo);
var
  v: Tvalue;
begin
  v := ap_iEditorFountain(real.EditorFountain, This);
  rb_iv_set(This, '@editor_fountain', v);
  rb_iv_set(This, '@brackets', rb_iv_get(v, '@brackets'));
  rb_iv_set(This, '@colors', rb_iv_get(v, '@colors'));
end;

function EditorViewInfo_alloc(This: Tvalue; real: TEditorViewInfo): Tvalue;
begin
  result := TmpAlloc(This, real);
  EditorViewInfo_setup(result, real);
end;

function ap_iEditorViewInfo(real: TEditorViewInfo; owner: Tvalue): Tvalue;
begin
  result := EditorViewInfo_alloc(cEditorViewInfo, real);
  ap_owner(result, owner);
end;

function ap_iEditorViewInfo_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorViewInfo(TEditorViewInfo(AControl), owner)
end;
procedure Init_EditorViewInfo;
begin
  cEditorViewInfo := rb_define_class_under(cEditor, 'ViewInfo', cNotifyPersistent);
  DefineProp(cEditorViewInfo, TEditorViewInfo);
  rb_define_attr(cEditorViewInfo, 'editor_fountain', 1, 0);
end;

end.
