unit uEditorFountain;

interface

uses
  Rubies, EditorFountain;

var
  cEditorColors, cEditorBracketCollection, cEditorFountain, cEditorParser: Tvalue;

function ap_iEditorColors(real: TEditorColors; owner: Tvalue): Tvalue;
function ap_iEditorBracketCollection(real: TEditorBracketCollection; owner: Tvalue): Tvalue;
function ap_iEditorFountain(real: TEditorFountain; owner: Tvalue): Tvalue;
procedure Init_EditorFountain;

implementation

uses
  uDefUtils, Pythia, heFountain, uEditor, uFountain, uFountainColor,
  uFountainBracketItem;

procedure EditorColors_setup(obj: Tvalue; real: TEditorColors);
begin
  rb_iv_set(obj, '@ank', ap_iFountainColor(real.Ank, obj));
  rb_iv_set(obj, '@comment', ap_iFountainColor(real.Comment, obj));
  rb_iv_set(obj, '@dbcs', ap_iFountainColor(real.DBCS, obj));
  rb_iv_set(obj, '@int', ap_iFountainColor(real.Int, obj));
  rb_iv_set(obj, '@mail', ap_iFountainColor(real.Mail, obj));
  rb_iv_set(obj, '@reserve', ap_iFountainColor(real.Reserve, obj));
  rb_iv_set(obj, '@select', ap_iFountainColor(real.Select, obj));
  rb_iv_set(obj, '@str', ap_iFountainColor(real.Str, obj));
  rb_iv_set(obj, '@symbol', ap_iFountainColor(real.Symbol, obj));
  rb_iv_set(obj, '@url', ap_iFountainColor(real.Url, obj));
end;

function EditorColors_alloc(klass: Tvalue; real: TEditorColors): Tvalue;
begin
  result := TmpAlloc(klass, real);
  EditorColors_setup(result, real);
end;

function ap_iEditorColors(real: TEditorColors; owner: Tvalue): Tvalue;
begin
  result := EditorColors_alloc(cEditorColors, real);
  ap_owner(result, owner);
end;

function EditorBracketCollection_alloc(klass: Tvalue; real: TEditorBracketCollection): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Collection_setup(result, real);
end;

function ap_iEditorBracketCollection(real: TEditorBracketCollection; owner: Tvalue): Tvalue;
begin
  result := EditorBracketCollection_alloc(cEditorBracketCollection, real);
  ap_owner(result, owner);
end;

function ap_iEditorBracketCollection_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorBracketCollection(TEditorBracketCollection(obj), owner)
end;

procedure EditorFountain_setup(This: Tvalue; real: TEditorFountain);
begin
  Fountain_setup(This, real);
  rb_iv_set(This, '@brackets', ap_iEditorBracketCollection(TEditorBracketCollection(real.Brackets), This));
  rb_iv_set(This, '@colors', ap_iEditorColors(real.Colors, This));
end;

function EditorFountain_alloc(This: Tvalue; real: TEditorFountain): Tvalue;
begin
  result := TmpAlloc(This, real);
  EditorFountain_setup(result, real);
end;

function ap_iEditorFountain(real: TEditorFountain; owner: Tvalue): Tvalue;
begin
  result := EditorFountain_alloc(cEditorFountain, real);
  ap_owner(result, owner);
end;

function ap_iEditorFountain_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorFountain(TEditorFountain(AControl), owner)
end;

function EditorFountain_new(This: Tvalue): Tvalue; cdecl;
var
  real: TEditorFountain;
begin
  real := TEditorFountain.Create(nil);
  result := CompoAlloc(This, real);
  EditorFountain_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

procedure Init_EditorFountain;
begin
  cEditorColors := rb_define_class_under(cEditor, 'EditorColors', ap_cObject);
  DefineProp(cEditorColors, TEditorColors);

  cEditorBracketCollection := DefinePersistentClass(ap_mPhi, TEditorBracketCollection, ap_cCollection, ap_iEditorBracketCollection_v);
  SetCollectionItemClass(cEditorBracketCollection, 'TFountainBracketItem');

  cEditorFountain := DefinePersistentClass(ap_mPhi, TEditorFountain, cFountain, ap_iEditorFountain_v);
  DefineProp(cEditorFountain, TEditorFountain);
  rb_define_singleton_method(cEditorFountain, 'new', @EditorFountain_new, 0);

  cEditorParser := rb_define_class_under(ap_mPhi, 'EditorParser', cFountainParser);
//  rb_define_method(cEditorParser, 'token_to_fountain_color', @EditorParser_token_to_fountain_color, 0);
end;

end.
