unit uEditorCaret;

interface

uses
  Rubies, HEditor;

var
  cEditorCaret: Tvalue;

function ap_iEditorCaret(real: TEditorCaret; owner: Tvalue): Tvalue;
procedure Init_EditorCaret;

implementation

uses
  Pythia, uEditor, uNotifyPersistent, uEditorCursor;

procedure EditorCaret_setup(This: Tvalue; real: TEditorCaret);
begin
  rb_iv_set(This, '@cursors', EditorCursors_alloc(cEditorCursors, real.Cursors));
end;

function EditorCaret_alloc(This: Tvalue; real: TEditorCaret): Tvalue;
begin
  result := TmpAlloc(This, real);
  EditorCaret_setup(result, real);
end;

function ap_iEditorCaret(real: TEditorCaret; owner: Tvalue): Tvalue;
begin
  result := EditorCaret_alloc(cEditorCaret, real);
  ap_owner(result, owner);
end;

function ap_iEditorCaret_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iEditorCaret(TEditorCaret(AControl), owner)
end;
procedure Init_EditorCaret;
begin
  DefineConstSetType(cEditor, TypeInfo(TEditorCaretStyle));

  cEditorCaret := rb_define_class_under(cEditor, 'Caret', cNotifyPersistent);
  DefineProp(cEditorCaret, TEditorCaret);
end;

end.
