unit uDraw;

interface

uses SysUtils, Classes, DXDraws, Rubies, uDefUtils, Pythia, uDirect, uSurface;

var
  cDraw: Tvalue;

function dx_iDraw(real: TDXDraw; owner: Tvalue): Tvalue;
procedure Init_Draw;

implementation

procedure Draw_setup(obj: Tvalue; real: TDXDraw);
begin
  rb_iv_set(obj, '@surface', dx_iSurface(real.Surface, obj));
//    AssignPropMethod(real, [PhiGetHandle]);
end;

function Draw_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle]);
  result := Qnil;
end;

function Draw_alloc(This: Tvalue; real: TDXDraw): Tvalue;
begin
  result := ChildAlloc(This, real);
  Draw_setup(result, real);
end;

function dx_iDraw(real: TDXDraw; owner: Tvalue): Tvalue;
begin
  result := Draw_alloc(cDraw, real);
  ap_owner(result, owner);
end;

function dx_iDraw_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := dx_iDraw(TDXDraw(AControl), owner)
end;

function Draw_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDXDraw;
begin
  real := TDXDraw.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  real.Initialize;
  Draw_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

function Draw_get_can_draw(This: Tvalue): Tvalue; cdecl;
var
  real: TDXDraw;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.CanDraw);
end;

function Draw_get_surface(This: Tvalue): Tvalue; cdecl;
begin
  result := rb_iv_get(This, '@surface');
end;

function Draw_flip(This: Tvalue): Tvalue; cdecl;
var
  real: TDXDraw;
begin
  real := ap_data_get_struct(This);
  real.Flip;
  result := This;
end;

function Draw_init(This: Tvalue): Tvalue; cdecl;
var
  real: TDXDraw;
begin
  real := ap_data_get_struct(This);
  real.Initialize;
  result := This;
end;

function Draw_finalize(This: Tvalue): Tvalue; cdecl;
var
  real: TDXDraw;
begin
  real := ap_data_get_struct(This);
  real.Finalize;
  result := This;
end;

procedure Init_Draw;
begin
  RegisterClass(TDXDraw);
  PhiAllocFuncList.AddObject('TDXDraw', @dx_iDraw_v);
  DefineConstSetType(mDirect, TypeInfo(TDXDrawOption));
  DefineConstSetType(mDirect, TypeInfo(TDXDrawNotifyType));
  cDraw := rb_define_class_under(mDirect, 'Draw', ap_cObject);
  DefineProp(cDraw, TDXDraw);
  rb_define_method(cDraw, 'event_handle', @Draw_event_handle, 1);
  DefineSingletonMethod(cDraw, 'new', Draw_new);
  DefineAttrGet(cDraw, 'can_draw?', Draw_get_can_draw);
  DefineAttrGet(cDraw, 'surface', Draw_get_surface);
  rb_define_method(cDraw, 'flip', @Draw_flip, 0);
  rb_define_method(cDraw, 'init', @Draw_init, 0);
  rb_define_method(cDraw, 'finalize', @Draw_finalize, 0);
end;

end.
