unit CommHandle;

interface

uses
  Windows, Classes, Rubies, CommX;

type
  TCommHandle = class(TObject)
  public
    procedure doReceive(Sender: TObject; ReceiveSize: Integer);
    procedure doBreak(Sender: TObject);
    procedure doError(Sender: TObject; ErrorState: Integer);
  end;

var
  rb_eCommError, cComm: Tvalue;

implementation

uses Pythia;

procedure TCommHandle.doReceive(Sender: TObject; ReceiveSize: Integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_receive'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(ReceiveSize));
  PhiCallProtect(data);
end;

procedure TCommHandle.doBreak(Sender: TObject);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_break'));
  rb_ary_push(data, recv);
  PhiCallProtect(data);
end;

procedure TCommHandle.doError(Sender: TObject; ErrorState: Integer);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_error'));
  rb_ary_push(data, recv);
  rb_ary_push(data, INT2FIX(ErrorState));
  PhiCallProtect(data);
end;

end.
