$KCODE = 'SJIS'

begin
  require 'conf_opt'
rescue
  DELPHI_VERSION = 6
  DELPHI_EDITION = 'ent'
  DIR_PAIR_LIST = [
  ]
end

DELPHI_PACKAGE = {
  'd6ent' => <<EOT,
vcl;rtl;dbrtl;adortl;vcldb;vclx;bdertl;vcldbx;ibxpress;dsnap;cds;bdecds;qrpt;teeui;teedb;tee;dss;teeqr;visualclx;visualdbclx;dsnapcrba;dsnapcon;VclSmp;vclshlctrls;vclie;vcljpg;xmlrtl;inet;inetdbbde;inetdbxpress;inetdb;nmfast;webdsnap;websnap;dbexpress;dbxcds;indy;dclOffice2k
EOT
  'd6pro' => <<EOT,
vcl;rtl;dbrtl;adortl;vcldb;vclx;bdertl;vcldbx;ibxpress;cds;bdecds;qrpt;teeui;teedb;tee;teeqr;visualclx;visualdbclx;VclSmp;vclshlctrls;vclie;vcljpg;xmlrtl;inet;inetdbbde;inetdbxpress;inetdb;nmfast;dbexpress;dbxcds;indy;dclOffice2k
EOT
  'd6per' => <<EOT,
vcl;rtl;vclx;VclSmp;vclshlctrls;vcljpg
EOT
  'd7pro' => <<EOT,
Packages=vcl;rtl;vclx;indy;vclie;xmlrtl;inetdbbde;inet;inetdbxpress;dbrtl;soaprtl;dsnap;VclSmp;dbexpress;vcldb;dbxcds;inetdb;bdertl;vcldbx;adortl;teeui;teedb;tee;ibxpress;visualclx;visualdbclx;vclactnband;vclshlctrls;IntrawebDB_50_70;Intraweb_50_70;Rave50CLX;Rave50VCL;dclOfficeXP
EOT
}["d#{DELPHI_VERSION}#{DELPHI_EDITION[0,3].downcase}"]

REPLACE_LU = '-LU' + DELPHI_PACKAGE
REPLACE_Packages = 'Packages=' + DELPHI_PACKAGE

def filter(glob_pattern)
  Dir.glob(glob_pattern){|entry|
    puts entry
    backup = entry + '~'
    File.rename entry, backup
    open(backup){|i|
    open(entry, 'w'){|o|
      yield i, o
    }}
  }
end

def replace_dir(line)
  DIR_PAIR_LIST.each do |pair|
    line.gsub!(Regexp.new(Regexp.escape(pair[0])+'\b', true), pair[1])
  end
end

def cfg_filter
  filter('**/*.cfg'){|i, o|
    while line = i.gets
      line.sub!(/^-LU.*/, REPLACE_LU)
      replace_dir line
      o.print line
    end
  }
end

def dof_filter
  filter('**/*.dof'){|i, o|
    while line = i.gets
      line.sub!(/^Packages=.*/, REPLACE_Packages)
      replace_dir line
      o.print line
    end
  }
end

def configure
  cfg_filter
  dof_filter
end

if $0 == __FILE__
  configure
end
