#!ruby -KS

interfaces = {}
Dir.glob('**/*.pas'){|path|
next if /Pythia/ =~ path
open(path){|f|
while line = f.gets
  case line
  when /^(?:function|procedure) ([\w\d]+)/
    name = $1
    interfaces[name] = line.sub(/$/, " external PhiDLL;")
  when /^implementation/
    break
  end
end
}
}

print <<EOT
unit Pythia;

interface

uses
{$IFDEF LINUX}
  Types,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  SysUtils, Classes,
{$IFDEF VCL}
  Controls, Forms, StdCtrls, ExtCtrls,
  Graphics, Menus, ComCtrls, Buttons, Mask,
{$ELSE}
  QControls, QForms, QStdCtrls, QExtCtrls,
  QGraphics, QMenus, QComCtrls, QButtons, QMask,
{$ENDIF}
  contnrs,
  TypInfo, Rubies, PhiHandle;

const
  PhiDLL = 'phi.so';

EOT

exports = {}
open('exports.inc'){|f|
while line = f.gets
  case line
  when /^$/, /^exports$/
    next
  when /^\{\$(.*?)\}/
    print line
    next
  when /([\w\d]+)[,;]$/
    name = $1
    exports[name] = true
    print interfaces[name] || "// no intf: #{name}\n"
  end
end
}

print <<EOT

implementation

end.
EOT
