=begin
  $Author: moriq $
  $Date: 2002-12-26 20:26:14 +0900 (Thu, 26 Dec 2002) $

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.
=end

require 'phi'
require 'simple-i18n'
require 'dialogs'

module ExtraDialog
  
  def self.Message
    SimpleI18N.Message
  end

  self.Message.set_message('message-dlg.txt')

  class BaseDialog < Phi::Form
    
    def initialize(form, title = '')
      super(form)
      self.caption = title
      #self.border_style = Phi::BS_DIALOG
      self.position = Phi::PO_SCREEN_CENTER
      @button_size = 70
      @margin = 5
    end

    # Stotal{^̂nthԖ(ԍ0Ԗ)̃{^
    # ׂē傫ŌŒ蕝āAEɊ񂹂Ĕzu
    def button_adjust(parent, button, nth, total)
      button.width = @button_size
      reverse_num = total - nth - 1
      button_left = parent.width - @margin - 
	( 10 + @button_size ) * ( reverse_num + 1)
      if (button_left < 0) or ( (button_left + @button_size) > parent.width) 
	print "Can't locate button in the Dialog Field: #{nth} of #{total}\n"
      end
      button.left = button_left
    end

    def set_center(parent, comp)
      comp.left = @margin 
      comp.width = parent.width - @margin * 2 - 5
    end

  end

  class QueryDialog < BaseDialog

    def initialize(form, title = '')
      super(form, title)
      msg = ExtraDialog.Message
      self.width = 300
      self.height = 100
      
      self.on_show = proc do 
	self.edit1.set_focus
      end

      button_top = 40

      ok = Phi::Button.new(self, :ok1, msg['ok'])
      ok.top = button_top
      button_adjust(self, ok, 0, 2)
      ok.modal_result = Phi::MR_OK

      cancel = Phi::Button.new(self, :cancel1, msg['cancel'])
      cancel.top = button_top
      button_adjust(self, cancel, 1, 2)
      cancel.modal_result = Phi::MR_CANCEL

      edit = Phi::Edit.new(self, :edit1)
      edit.top = 10
      edit.left = 10
      edit.width = self.width - 25
      edit.text = ''

      edit.on_key_down = proc do |edit_com, key_code, hoge|
	if (edit_com.text != '') and (key_code == Phi::VK_RETURN) # Return
	  self.ok1.click
	end
      end
    end
    
    def text
      self.edit1.text
    end

    def text=(str)
      self.edit1.text = str
    end

  end

  class QueryDirDialog < QueryDialog
    
    def initialize(form, title = '')
      super(form, title)
      msg = ExtraDialog.Message
      ref_btn = Phi::Button.new(self, :ref1, msg['browse'])
      ref_btn.top = self.ok1.top
      result_path = ''
      
      ref_btn.on_click = proc do
	if Phi.select_dir(msg['dir_select'], '', result_path)	  
	  self.edit1.text = File::expand_path(result_path) 
	end
	self.edit1.set_focus
      end

      self.ok1.tab_order = 0
      self.cancel1.tab_order = 1
      ref_btn.tab_order = 2

      button_adjust(self, self.ok1, 0, 3)
      button_adjust(self, self.cancel1, 1, 3)
      button_adjust(self, ref_btn, 2, 3)
    end

  end

end



if $0 == __FILE__
  dlg = ExtraDialog::QueryDirDialog.new(:form1, 'hoge') 
  dlg.show_modal
  Phi.mainloop
end
