require 'phi'
require 'irb-wrapper'
require 'message-irb'
require 'irb-editor'
require 'dialogs'

module ApIRB

  class IRBWindow < Phi::Form

    def initialize
      super
      @editor = ApIRB::IRBEditor.new(self, :editor1)
      @editor.align = Phi::AL_CLIENT
      create_menu
    end
    
    def create_menu
      msg = ApIRB.Message
      Phi.new_menu(self, :menu1, [
          Phi.new_item(msg['menu_file'], '', :mi_file).add(
	  menu_save = Phi.new_item(msg['menu_save_as'], '', :mi_save_as),
          Phi.new_line,
          menu_exit = Phi.new_item(msg['menu_close'], '', :mi_exit)
	),
        Phi.new_item(msg['menu_edit'], '', :mi_edit).add(
          menu_undo = Phi.new_item(msg['menu_undo'], 'Ctrl+Z', :mi_undo),
          menu_redo = Phi.new_item(msg['menu_redo'], 'Ctrl+A', :mi_redo),
          Phi.new_line,
          menu_cut = Phi.new_item(msg['menu_cut'], 'Ctrl+X', :mi_cut),
	  menu_copy = Phi.new_item(msg['menu_copy'], 'Ctrl+C', :mi_copy),
          menu_paste = Phi.new_item(msg['menu_paste'], 'Ctrl+V', :mi_paste),
          menu_delete = Phi.new_item(msg['menu_delete'], '', :mi_delete),
          Phi.new_line,
          menu_select_all = Phi.new_item(msg['menu_select_all'], '', :mi_select_all)
        ),
        Phi.new_item(msg['menu_input_helper'], '', :mi_input_helper).add(
	  menu_prev_history = Phi.new_item(msg['menu_prev_history'], 'Ctrl+P', :mi_prev_history),
          menu_next_history = Phi.new_item(msg['menu_next_history'], 'Ctrl+N', :mi_next_history),
          menu_completion = Phi.new_item(msg['menu_completion'], 'Tab', :mi_completion)
        ),
        Phi.new_item(msg['menu_help'], '', :mi_help).add(
	  menu_about = Phi.new_item(msg['menu_about'], '', :mi_about)
	),
      ])

      # t@C
      #self.mi_exit.on_click = proc do 
      menu_exit.on_click = proc do 
	exit
      end

      menu_save.on_click = proc do
	dlg = Phi::SaveDialog.new
	dlg.filter = msg['file_save_dlg_filter']
	dlg.default_ext = 'txt'
	if dlg.execute
	  filename = File::expand_path(dlg.file_name)
	  if FileTest::file?(filename)
	    result = Phi::message_dlg(filename + "\n" + msg['save_confirm'], 
				      Phi::MT_CONFIRMATION, [Phi::MB_OK, Phi::MB_CANCEL])
	    if result == Phi::MR_OK
	      begin
		@editor.lines.save(filename)
	      rescue
		Phi::message_dlg(msg['save_error'], Phi::MT_ERROR, [Phi::MB_OK])
	      end
	    end
	  elsif FileTest::writable?(File::dirname(filename))
	    begin
	      @editor.lines.save(filename)
	    rescue
	      Phi::message_dlg(msg['save_error'], Phi::MT_ERROR, [Phi::MB_OK])
	    end
	  else
	    Phi::message_dlg(msg['has_no_write_right'], Phi::MT_ERROR, [Phi::MB_OK])
	  end
	end
      end

      # ҏW
      menu_undo.on_click = proc do
	if @editor.can_undo 
	  @editor.undo
	end
      end

      menu_redo.on_click = proc do
	if @editor.can_redo 
	  @editor.redo
	end
      end

      # selectedg
      #self.mi_cut.on_click = proc do
      menu_cut.on_click = proc do
  	@editor.cut_to_clipboard
      end

      #self.mi_copy.on_click = proc do 
      menu_copy.on_click = proc do 
	@editor.copy_to_clipboard
      end

      #self.mi_paste.on_click = proc do
      menu_paste.on_click = proc do 
	@editor.paste_from_clipboard
      end

      #self.mi_delete.on_click = proc do
      menu_delete.on_click = proc do 
      end

      #self.mi_select_all.on_click = proc do 
      menu_select_all.on_click = proc do 
	@editor.select_all
      end

      # ͎x
      #self.mi_prev_history.on_click = proc do
      menu_prev_history.on_click = proc do
	@editor.history.previous(@editor.last_char_point_of_buffer_write)
      end

      #self.mi_next_history.on_click = proc do
      menu_next_history.on_click = proc do 
  	@editor.history.next(@editor.last_char_point_of_buffer_write)
      end

      #self.mi_completion.on_click = proc do
      menu_completion.on_click = proc do 
	@editor.complete
      end

    end

  end
  
end



#
# Main
#

irb_w = ApIRB::IRBWindow.new

# $> $stdout $stdin $stderr ւ
$> = GUIWrapper::GuiConsole.new(irb_w.editor1)
include GUIWrapper::GuiIoEmulate
$stdout = $>
$stdin = $>
$stderr = $>

irb_w.show
irb_w.height = 400
irb_w.width = 600
irb_w.caption = "Apollo IRB"

IRB.start_on_gui
Phi.mainloop
