#!/usr/bin/env ruby

$:.push File.expand_path(File.join(File.dirname(__FILE__), '../lib'))
$:.push File.expand_path(File.dirname(__FILE__))

case RUBY_PLATFORM
when /win32/, /mingw/, /cygwin/
  require 'win32.rb'
else
  require 'linux.rb'
end

# Phi::APPLICATION.create_handle

module Phi
  EventHandle = {}
  class Persistent
  private
    def singleton_method_added(id)
p [:s, id] if $DEBUG
      return unless self.respond_to? :event_handle
      case id.to_s
      when /^on_/, /^after_/, /^before_/
        self.event_handle id
      end
    end
    
    def Persistent.method_added(id)
p [:m, id] if $DEBUG
      case id.to_s
      when /^on_/, /^after_/, /^before_/
        if EventHandle[self].nil?
           EventHandle[self] = []
        end
        EventHandle[self].push id
      end
    end
    
    def extend(mod)
      super(mod)
      return unless self.respond_to? :event_handle
p [:e, mod] if $DEBUG
      mod.instance_methods.each do |name|
        case name
        when /^on_/, /^after_/, /^before_/
          self.event_handle name.intern
        end
      end
    end
    public :extend
    
    def Persistent.include(mod)
      super(mod)
p [:i, mod] if $DEBUG
      mod.instance_methods.each do |name|
        case name
        when /^on_/, /^after_/, /^before_/
          if EventHandle[self].nil?
             EventHandle[self] = []
          end
          EventHandle[self].push name.intern
        end
      end
    end
    
    def initialize(*args)
    p [:initialize, EventHandle, type] if $DEBUG
      super(*args)
      if EventHandle[self.class]
         EventHandle[self.class].each do|id|
           begin
             event_handle id
           rescue DelphiError
             #
           end
         end
      end
    end
    
  end
end

Phi.date_format = "yyyy/mm/dd"
Phi.time_format = "hh:mm:ss"

module Phi
  module Enumerable
    include ::Enumerable
    def each
      (0...self.count).each{|i| yield self[i]}
    end
  end
  
  module ItemsEnumerable
    include ::Enumerable
    def each
      (0...self.items.count).each{|i| yield self.items[i]}
    end
  end
  
  class Strings     ; include Phi::Enumerable ; end
  class MenuItem    ; include Phi::Enumerable ; end
  class TreeNode    ; include Phi::Enumerable ; end
  class TreeNodes   ; include Phi::Enumerable ; end
  class ListItems   ; include Phi::Enumerable ; end
  class ListColumns ; include Phi::Enumerable ; end
  class PopupMenu   ; include Phi::ItemsEnumerable ; end
  class TreeView    ; include Phi::ItemsEnumerable ; end
end

module Phi
  module MenuContainer
  private
    def define_child_attr(this)
      return unless this
      @child_attr_module.module_eval do
        define_method(Phi.downcase(this.name)){ this }
      end unless this.name.empty?
      this.each do |item|
        define_child_attr(item)
      end
    end
  public
    def menu_attr_flatten
      define_child_attr(defined?(self.menu) ? menu.items : items)
    end
    
  end
  
  class Form        ; include Phi::MenuContainer ; end
  class MainMenu    ; include Phi::MenuContainer ; end
  class PopupMenu   ; include Phi::MenuContainer ; end
end

module Phi
  module ControlContainer
  private
    def each_define_child_attr(controls)
      controls.each do |this|
        @child_attr_module.module_eval do
          define_method(Phi.downcase(this.name)){ this }
        end unless this.name.empty?
        each_define_child_attr(this.controls) if this.respond_to? :controls
      end
    end
  public
    def control_attr_flatten
      each_define_child_attr(controls)
    end
  end
  
  class Form        ; include Phi::ControlContainer ; end
end

module Phi
  class Control
    def right
      self.left + self.width
    end
    def bottom
      self.top + self.height
    end
    # ap-dev:0748
    def right=(v)
      self.left = v - self.width
    end
    def bottom=(v)
      self.top = v - self.height
    end
  end
end

# ap-list:2135
module Phi
  class MaskEdit
    alias edit_mask_= edit_mask=
    def edit_mask=(v)
      tx = self.text
      self.edit_mask_= v
      self.text = tx
    end
  end
end

module Phi
  class Control
    def parent_form
      form = self
      form = form.parent while not ( form.is_a? Form )
      return form
    end
  end
end

# ap-list:2779
module Phi
  class Rect
    def ===(point)
      (left..right) === point.x && (top..bottom) === point.y
    end
  end
end

# ap-dev:0750
module Phi
  class DateTime
    
    alias :succ           :inc_day
    
    alias :begin_of_day   :start_of_day
    alias :begin_of_month :start_of_month
    alias :begin_of_year  :start_of_year
    
    #alias :last_of_day    :end_of_day
    #alias :last_of_month  :end_of_month
    #alias :last_of_year   :end_of_year
    
  end
end

# partition( &block )
#   alias divide
#   ubN]l^łvfSĊ܂ޔz
#   ubN]lUłvfSĊ܂ޔz
#   g(z)ԂB
#   see: ruby-talk:12330

module Enumerable
  def partition
    matching, nonmatching = [], []
    each{|e| yield(e) ? matching.push(e) : nonmatching.push(e)}
    return matching, nonmatching
  end
  alias divide  partition 
end

# partition!( &block )
#   alias divide!
#   ubN]l^łvfSĊ܂ޔzԂB
#   self ̓e
#   ubN]lUłvfSĊ܂ޔz̓e
#   uB
#   see: Enumerable#partition, Array#replace

class Array
  def partition!( &block )
    ret1, ret2 = partition( &block )
    self.replace ret2
    ret1
  end
  alias divide! partition!
end

module Phi
  @@uniq_id = 0
  
  #  j[N ID 炵̂Ԃ
  def Phi.uniq_id(prefix='id_')
    @@uniq_id += 1
    "#{prefix}#{@@uniq_id}".intern
  end
  
  # name ȗ\
  # on_click  hint  add Ŏw\ Phi::new_item
  #   Symbol Ȃ name
  #   String Ȃ hint
  #   Array  Ȃ add ŉTuACe̔z
  #   Proc   Ȃ on_click ̃\bh
  def Phi.new_item_ex(caption, shortcut='', *args)
    name, hint, proc, subs, *rest = []
    args.each{|e|
      case e
      when Symbol
        if name then raise ArgmentError, "too many Symbols for name" end
        name = e
      when String
        if hint then raise ArgmentError, "too many Strings for hint" end
        hint = e
      when Proc
        if proc then raise ArgmentError, "too many Procs for on_click" end
        proc = e
      when Array
        if subs then raise ArgmentError, "too many Arrays for items" end
        subs = e
      else
        rest.push e
      end
    }
    item = Phi.new_item(caption, shortcut, name || uniq_id('mi_'), *rest)
    item.hint     = hint if hint
    item.on_click = proc if proc
    item.add(*subs)      if subs
    item
  end
end

