require 'phi'; include Phi

module OI
  def _oi() end
end

def om(obj)
  p obj
  tab_sheet = TabSheet.new @form.page, :om_tab_sheet, obj.type.name
  tab_sheet.extend OI
  view = ListView.new tab_sheet
  view.extend OI
  view.align = AL_CLIENT
# view.icon_options.auto_arrange = true
  view.view_style = VS_LIST

  view.on_dbl_click = proc do
    break if view.selected.nil?
    begin
      om obj.send view.selected.caption
    rescue Exception
      p $!
    end
  end

  obj.singleton_methods.each do |name|
    item = view.items.add
    item.extend OI
    item.caption = name
  end

  obj.methods.each do |name|
    item = view.items.add
    item.extend OI
    item.caption = name
  end

  def view.on_drag_over(accept, src, x, y, state)
    true
  end

  view.on_drag_drop = proc do |sender, src, x, y|
    break if view.item_at(x, y).nil?
    begin
      om obj.send view.item_at(x, y).caption, src.selected.data
    rescue Exception
      p $!
    end
  end

  tab_sheet
end

def oi
  @form = Form.new :oi_form, 'oi'
  @form.extend OI
  view = ListView.new @form
  view.extend OI
  view.align = AL_CLIENT
# view.icon_options.auto_arrange = true
  view.view_style = VS_LIST
  page = PageControl.new @form, :page
  page.align = AL_LEFT

  ObjectSpace.each_object(Object) do |obj|
    next if obj.respond_to? :_oi
    next if obj.is_a? String
    item = view.items.add
    item.extend OI
    item.caption = obj.type.name #bug: obj.inspect
    item.data = obj
  end

  view.on_dbl_click = proc do
    break if view.selected.nil?
    tab_sheet = om view.selected.data
  # tab_sheet.page_control = page
  end

  view.on_change = proc do
    break if view.selected.nil?
    begin
      p view.selected.data
    rescue Exception
      p $!
    end
  end

  def view.on_mouse_down(btn, shift, x, y)
    begin_drag false, 10
  end

  @form.show
end

oi

mainloop
