require 'phi'

def component_p(this,lev=0)
  print '  '*lev
  if this.is_a? Phi::Component
    print Phi.downcase(this.name), ': ', this.type.name, "\n"
  else
    print 'unknown: ', this.inspect, "\n"
  end
end

def control_p(this,lev=0)
  this.components.each {|i|
    next if i.is_a? Phi::Control
    component_p i, lev
  }
  print '  '*lev
  if this.is_a? Phi::Control
    print Phi.downcase(this.name), ': ', this.type.name, "\n"
    if this.is_a? Phi::WinControl
      this.controls.each {|i| control_p i, lev+1 }
    end
  else
    print 'unknown: ', this.inspect, "\n"
  end
end

def menu_node(this,lev=0)
  print '  '*lev
  if this.is_a? Phi::MenuItem
    print Phi.downcase(this.name), ': ', this.type.name, "\n"
    this.each { |i| menu_node i, lev+1 }
  else
    print 'unknown: ', this.inspect, "\n"
  end
end

print '--', "\n"
print 'Phi::SCREEN', "\n"
Phi::SCREEN.forms.each do |i|
  control_p i, 1
  menu_node i.menu.items, 1+1 if i.menu
end
print '--', "\n"
