! See copyright notice in the COPYRIGHT file.
! ******************************************************************************!
module hvs_sizeof_module

  ! include treelm modules
  use env_module, only: rk, long_k

  use, intrinsic :: iso_c_binding, only: c_double, c_float, c_int, c_char,     &
    &                                    c_int_least8_t, c_int_least64_t

  implicit none

  private

  public :: c_sizeof

  interface c_sizeof
    module procedure sizeof_float
    module procedure sizeof_double
    module procedure sizeof_int
    module procedure sizeof_char
    module procedure sizeof_int_least8
    module procedure sizeof_int_least64
  end interface c_sizeof

contains

! ******************************************************************************!
  function sizeof_float(arg) result(argsize)
    ! ---------------------------------------------------------------------------
    real(kind=c_float), intent(in) :: arg
    integer :: argsize
    ! ---------------------------------------------------------------------------
    argsize = 4
  end function sizeof_float
! ******************************************************************************!


! ******************************************************************************!
  function sizeof_double(arg) result(argsize)
    ! ---------------------------------------------------------------------------
    real(kind=c_double), intent(in) :: arg
    integer :: argsize
    ! ---------------------------------------------------------------------------
    argsize = 8
  end function sizeof_double
! ******************************************************************************!


! ******************************************************************************!
  function sizeof_int(arg) result(argsize)
    ! ---------------------------------------------------------------------------
    integer(kind=c_int), intent(in) :: arg
    integer :: argsize
    ! ---------------------------------------------------------------------------
    argsize = 4
  end function sizeof_int
! ******************************************************************************!


! ******************************************************************************!
  function sizeof_int_least8(arg) result(argsize)
    ! ---------------------------------------------------------------------------
    integer(kind=c_int_least8_t), intent(in) :: arg
    integer :: argsize
    ! ---------------------------------------------------------------------------
    argsize = 1
  end function sizeof_int_least8
! ******************************************************************************!


! ******************************************************************************!
  function sizeof_int_least64(arg) result(argsize)
    ! ---------------------------------------------------------------------------
    integer(kind=c_int_least64_t), intent(in) :: arg
    integer :: argsize
    ! ---------------------------------------------------------------------------
    argsize = 8
  end function sizeof_int_least64
! ******************************************************************************!


! ******************************************************************************!
  function sizeof_char(arg) result(argsize)
    ! ---------------------------------------------------------------------------
    character(kind=c_char), intent(in) :: arg
    integer :: argsize
    ! ---------------------------------------------------------------------------
    argsize = 1
  end function sizeof_char
! ******************************************************************************!


end module hvs_sizeof_module
! ******************************************************************************!
