! See copyright notice in the COPYRIGHT file.
program tem_tracking_test
  use, intrinsic :: iso_c_binding, only: C_NEW_LINE
  use mpi
  ! incude treelm modules
  use env_module,             only: solSpecLen
  use tem_tracking_module,    only: tem_tracking_type, &
    &                               tem_load_tracking

  ! include aotus modules
  use aotus_module,           only: flu_State, close_config,      &
    &                               open_config_chunk

  implicit none

  character, parameter :: nl = C_NEW_LINE
  type(tem_tracking_type) :: track
  type(flu_State) :: conf
  integer :: iError

  character(len=solSpecLen), parameter :: sysConf =            &
    &    'tracking = {'                                  // nl &
    & // '  label = "point",'                            // nl &
    & // '  variable = { "density", "velocity" },'       // nl &
    & // '  folder = "tracking_",'                       // nl &
    & // '  shapce = { kind = "all" },'                  // nl &
    & // '  output = { format = "ascii" },'              // nl &
    & // '  time = { min = 1, max = 10, interval = 1 },' // nl &
    & // '}'

  call MPI_Init(iError)

  call open_config_chunk( L     = conf,         &
    &                     chunk = trim(sysConf) )

  ! load tracking
  call tem_load_tracking( me   = track, &
    &                     conf = conf   )

  call close_config( L = conf )
  write(*,*) 'PASSED'

  call MPI_Finalize(iError)

end program tem_tracking_test
