program tem_tools_test

  use env_module,       only: rk, long_k
  use tem_tools_module, only: tem_getOptValOrDef
  use tem_float_module, only: operator(.feq.)

  implicit none

  logical :: res = .true.

  res = res .and. test_character() == 'X'
  res = res .and. test_character('Y') =='Y'
  res = res .and. test_int() == 42
  res = res .and. test_int(23) == 23
  res = res .and. test_logical() .eqv. .true.
  res = res .and. test_logical(.false.) .eqv. .false.
  res = res .and. test_long() == 42_long_k
  res = res .and. test_long(23_long_k) == 23_long_k
  res = res .and. (test_real() .feq. 4.2_rk)
  res = res .and. (test_real(2.3_rk) .feq. 2.3_rk)

  if(res) write(*,*) 'PASSED'

contains

  function test_character(char) result(res)
    character :: res
    character, intent(in), optional :: char
    res = tem_getOptValOrDef(char,'X')
  end function

  function test_int(int) result(res)
    integer :: res
    integer, intent(in), optional :: int
    res = tem_getOptValOrDef(int,42)
  end function

  function test_logical(bool) result(res)
    logical :: res
    logical, intent(in), optional :: bool
    res = tem_getOptValOrDef(bool,.true.)
  end function

  function test_long(long) result(res)
    integer(kind=long_k) :: res
    integer(kind=long_k), intent(in), optional :: long
    res = tem_getOptValOrDef(long,42_long_k)
  end function

  function test_real(float) result(res)
    real(kind=rk) :: res
    real(kind=rk), intent(in), optional :: float
    res = tem_getOptValOrDef(float,4.2_rk)
  end function

end program tem_tools_test
