module mem_for_mpi_module
  use mpi_f08

  implicit none


contains


  subroutine alloc_mpif_mem(asize, baseptr, ierr)
    integer(kind=MPI_ADRESS_KIND), intent(in) :: asize
    type(c_ptr), intent(out) :: baseptr
    integer, optional, intent(out) :: ierr

    call MPI_Alloc_mem( size    = asize,         &
      &                 info    = MPI_INFO_NULL, &
      &                 baseptr = baseptr,       &
      &                 ierr    = ierr           )

  end subroutine alloc_mpif_mem


  subroutine free_mpif_mem(baseptr, ierr)
    type(c_ptr) :: baseptr
    integer, optional, intent(out) :: ierr

    call MPI_Free_mem( baseptr = baseptr, &
      &                ierr    = ierr     )

  end subroutine free_mpif_mem

end module mem_for_mpi_module
