! See copyright notice in the COPYRIGHT file.
!> \brief This module is an adapter to tem_triangle_module, Contains 
!! a routine to load triangle and added it to list of spatial objects
module sdr_triangle_module
  use tem_logging_module,        only: logunit
  use tem_transformation_module, only: tem_transformation_type  
  use tem_triangle_module,       only: tem_triangle_type,      &
    &                                  grw_triangleArray_type, &
    &                                  tem_load_triangle, append

  use aotus_module,              only: flu_State

  use sdr_spatialObj_module,     only: grw_spatialObjArray_type,               &
    &                                  sdr_spatialObj_type, append,            &
    &                                  triangle

  implicit none

  private

  public :: sdr_load_triangle

contains

  ! ****************************************************************************
  !> Load triangle information from config file.
  subroutine sdr_load_triangle(triArray, spaObjArray, attr_pos, transform, &
    &                          conf, thandle )
    !--------------------------------------------------------------------------!
    !inferface variables
    !> growing array of triangles
    type(grw_triangleArray_type), intent(inout) :: triArray
    !> growing array of geometrical objects.
    type( grw_spatialObjArray_type), intent(inout) :: spaObjArray
    !> Position of the attribute to connect this object to.
    integer, intent(in) :: attr_pos
    !> transformation for spatial object
    type(tem_transformation_type), intent(in) :: transform 
    !> lua state
    type(flu_state) :: conf 
    integer, intent(in) :: thandle !< handle for canonical objects
    !--------------------------------------------------------------------------!
    ! local varaibles
    type(tem_triangle_type), allocatable :: loc_triangle(:)
    type(sdr_spatialObj_type) :: spatialObj 
    integer :: iTri
    !--------------------------------------------------------------------------!

    call tem_load_triangle( me        = loc_triangle, &
      &                     transform = transform,    &
      &                     conf      = conf,         &
      &                     thandle   = thandle       )

    !append triangle to triangle array
    spatialObj%attribute_position = attr_pos
    spatialObj%geometry_primitive = triangle

    do iTri = 1, size(loc_triangle)
      call append( triArray, loc_triangle(iTri) )

      spatialObj%primitive_position = triArray%nVals

      !add spatialObj to spatialObj list
      call append(spaObjArray, spatialObj)
    end do

  end subroutine sdr_load_triangle
  ! ****************************************************************************

end module sdr_triangle_module
