! See copyright notice in the COPYRIGHT file.
!******************************************************************************!
!> Some auxilary functionalities.
module sdr_aux_module

  ! treelm modules
  use tem_aux_module,       only: tem_print_execInfo
  use tem_logging_module,   only: logunit
  use tem_solveHead_module, only: tem_solveHead_type

  implicit none

  private

  public :: sdr_init_global

contains

  ! ****************************************************************************!
  !> Prominently let the user now, what he actually is running right now.
  !!
  !! Also set the solvername and version number in the solveHead.
  subroutine sdr_init_global(solveHead)
    !> contains solver header information
    type( tem_solveHead_type ), intent(in) :: solveHead

    write(logunit(1),*) "                                             "
    write(logunit(1),*) "                              _              "
    write(logunit(1),*) "            ___  ___  ___  __| | ___ _ __    "
    write(logunit(1),*) "           / __|/ _ \/ _ \/ _` |/ _ \ '__|   "
    write(logunit(1),*) "           \__ \  __/  __/ (_| |  __/ |      "
    write(logunit(1),*) "           |___/\___|\___|\__,_|\___|_"      &
                        // trim(solveHead%version)
    write(logunit(1),*) "                                             "
    write(logunit(1),*) &
      &  " (C) 2012 German Research School for Simulation Sciences"
    write(logunit(1),*) " (C) 2013 University of Siegen               "
    write(logunit(1),*) "                                             "
    ! Write the information about the executable, gathered at build time to
    ! the screen.
    call tem_print_execInfo()
    write(logunit(1),*) "                                             "
    write(logunit(1),*) "                                             "

  end subroutine sdr_init_global
  ! ****************************************************************************!


end module sdr_aux_module
! ******************************************************************************!
