project: Seeder
summary: Mesh generator, providing the mesh with tree information.
src_dir: source/
src_dir: build/ford
src_dir: polynomials/source
exclude_dir: build/ford/treelm
external: https://geb.sts.nt.uni-siegen.de/doxy/aotus/
external: https://geb.sts.nt.uni-siegen.de/doxy/treelm/
output_dir: docu
page_dir: doc_pages
media_dir: treelm/media
project_bitbucket: https://bitbucket.org/apesteam/seeder
graph: true
graph_maxdepth: 4
graph_maxnodes: 32
display: public
display: protected
display: private
sort: permission
source: false
author: University of Siegen
title: Mainpage
print_creation_date: True

Seeder Mesh Generator
=====================

The goal of Seeder is simple: create an octree mesh out of a given geometry.
Typically the geometry is given in the form of
[STL](page/features/stl.html)-files.
As simple as this goal is the basic idea for the construction of this mesh.
The user first has to describe the cubical outline of the mesh, which has to
enclose the complete geometry.
This is referred to as `bounding_cube`.
It is the root node of the octree, from which all elements of the mesh are
derived by recursive bisection in all three spatial dimensions.
The generated mesh will be written to the location provided by the `folder`
setting.
This either is simply a prefix to use for all mesh file names or a directory,
if it is a directory, the string has to include the path-separator at the end,
and the directory has to exist.
A third global setting can be used to define a minimial refinement level to
use for all elements that will be part of the final mesh.
This `minlevel` setting provides a method to prescribe a minimal resolution
for the complete domain, if it is not provided the resolution will only be
defined by the geometrical objects you put into the bounding cube.
See the [fully periodic cube](page/testsuite_tutorials/ful_per_cube.html)
example for a mesh that uses only these three settings.

Getting Started
---------------

-   [Quick Start: Building and Compiling Seeder](page/index.html) 
-   [Treelm Requirements](page/treelm/page/requirements.html)
-   [Testsuite](page/testsuite_tutorials/index.html): An introduction to the
    usage of the features of Seeder. You are guided through all required steps
    to generate meshes with different configurations.
-   [Transformations](page/features/transformation.html) like translation,
    scaling, reflection and rotation can be applied to all geometric objects.
-   Geometric definitions, have to be given one of the
    [attributes](page/attributes/index.html).

    Attributes are defined by their `kind`:

    * [Boundary](page/attributes/boundary.html)
    * [Seed](page/attributes/seed.html)
    * [Refinement](page/attributes/refinement.html) *level*, that describes the
      minimal refinement level by which the object should be resolved
    * and some kind specific further values, like a label for boundary
      conditions


For some further internal details see:

- the [overall algorithm](page/sdr_algorithm.html).

- [Octree](page/treelm/page/octree.html) describes the implementation of the
  Octree data structure in a little more detail.

- [Treelm](page/treelm/index.html) is a common library that implements the
  octree mesh handling for the solvers.

- [Aotus](page/treelm/page/aotus_dir/index.html) is a library that provides
  the access to Lua scripts as configuration files.
