Seeder Mesh Generator
=====================

The goal of Seeder is simple: create an octree mesh out of a given geometry.
Typically the given geometry is given in the form of STL-files.
As simple as this goal is the basic idea for the construction of this mesh.
The user has to define at least the basic mesh information to generate the
most simplest mesh, fully periodic cube without 
any geometries. Basic mesh information are bounding cube,
minlevel and folder. *Bounding cube* is the root node of the octree,
defining the complete universe, from which all element are derived by 
recursive bisection, global *minlevel* is the minimum refinement in the 
fluid domain and *folder* is the location to dump the mesh output in treelm 
format.

The user can also define a set of geometries, that should describe certain
aspects in the mesh. Most importantly the boundaries of the computational
domain. Those have to consist of some supported geometric primitives, right
now the following primitives are available:

- Points
- Lines
- Triangles
- Boxes
- Spheres
- Cylinders

Additionally some combining objects like Planes and 
STL-files can be used.
They are automatically translated to these primitives.

Transformations like translation, scaling,
reflection and rotation can be applied to all geometric primitives.

Finally, those geometric definitions, have to be given one of the
attributes.
Attributes are defined by their *kind*:

- Boundary
- Seed
- Refinement

a *level*, that describes the minimal refinement level by which the object
should be resolved and some kind specific further values, like a label for
the boundary conditions.

For further details see the
[FORD generated documentation](https://geb.sts.nt.uni-siegen.de/doxy/seeder/index.html).

Included Software
-----------------

Note, that this source code includes some other software parts to your convenience.

- [Treelm](https://bitbucket.org/apesteam/treelm/) is the central library
  providing the octree infrastructure. It is available under the terms of the
  BSD License.
- [Aotus](https://bitbucket.org/apesteam/aotus/) is used for configuration and header
  files. It is released under the terms of the MIT License as the
  [Lua library](http://www.lua.org), that it includes.
- [Waf](http://code.google.com/p/waf/) is used as the build system and is released
  under the terms of the BSD license.
- [CoCo](http://users.erols.com/dnagle/coco.html) is used to preprocess Fortran
  source files and is released under the terms of the GPLv2.
- For the intersection check of triangles with axis aligned boxes we make use of
  the code developed by Tomas Akenine-Möller, available at the
  [Lunds Universitet](http://fileadmin.cs.lth.se/cs/Personal/Tomas_Akenine-Moller/pubs/tribox.pdf)


License
=======

Seeder is licensed under the terms of the 2-clause BSD license reproduced below.
This means that Seeder is free software and can be used, reproduced, modified,
distributed and redistributed also for commercial purposes under the conditions
of the BSD license.
The only requirement is that some credit to the authors is given by putting this
copyright notice somewhere in your project.

According to good scientific practice, publications on results achieved in whole
or in part due to Seeder should cite at least one paper presenting the Seeder
software.

An appropriate reference could be:

    @incollection{harlacher_seeder12,
       author = {Harlacher, Daniel F. and Hasert, Manuel and Klimach, Harald and Zimny, Simon and Roller, Sabine},
       affiliation = {German Research School for Simulation Sciences GmbH, and RWTH, Aachen, Germany},
       title = {Tree Based Voxelization of STL {Data}},
       booktitle = {High Performance Computing on Vector Systems 2011},
       editor = {Resch, Michael and Wang, Xin and Bez, Wolfgang and Focht, Erich and Kobayashi, Hiroaki and Roller, Sabine},
       publisher = {Springer Berlin Heidelberg},
       pages = {81-92},
       year = {2012}
    }

---
Copyright (C) 2011-2013 German Research School for Simulation Sciences GmbH, Aachen.
Copyright (C) 2013-2019 University of Siegen.
All rights reserved.
 
Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
 
1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
 
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY GERMAN RESEARCH SCHOOL FOR SIMULATION SCIENCES
GMBH, AACHEN “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERMAN RESEARCH SCHOOL FOR
SIMULATION SCIENCES GMBH, AACHEN OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of German Research School for Simulation Sciences
GmbH, Aachen or University of Siegen.
