# Parameters for the Musubi recheck runs.

#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#! Full list of testcases that should be in recheck:                            !
#! https://geb.sts.nt.uni-siegen.de/collab/projects/musubi/wiki/Testcases       !
#! If you add a new testcase to recheck please update the Wiki page given above !
#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

import os
import sys
import datetime
import shutil

from clone_and_build_function import *

templateFolder = './templates/'
machineFolder = './machines/'
apesFolder = os.getenv('HOME')+'/apes/'

date = datetime.datetime.now().strftime("%Y-%m-%d__%X")
weekday = datetime.datetime.now().strftime("%A")

# Production directory, keep the past week as history.
prod_dir = 'musubi-runs_' + weekday

run_label = 'MUSUBI'

# Cleanup production directory before using it:
shutil.rmtree(prod_dir, ignore_errors=True)
loglevel = 'INFO'

hg_clone_source = 'ssh://geb.sts.nt.uni-siegen.de//var/www/repos/hg/'

from recheck import notify_list
mail_address = notify_list

musubi_test = apesFolder + 'musubi/examples/'

# name of the shepherd log file
shepherd_out = 'shepherd.log'

# name of the log and rror file of the clone and build function
clone_build_out = 'clone_build.log'
clone_build_err = 'clone_build_error.log'

create_tag_on = True
grep_performance = True
loris_clone_url = apesFolder + 'loris/'

shepherd_jobs = []

# Use the latest revision
seeder_exe = clone_build( solver          = 'seeder',
        revision        = 'default',
        hg_clone_source = hg_clone_source+'seeder',
        solver_dir      = 'seeder',
        clone_build_out = clone_build_out,
        clone_build_err = clone_build_err         )

musubi_exe = clone_build( solver          = 'musubi',
        hg_clone_source = hg_clone_source+'musubi',
        solver_dir      = 'musubi',
        # confopts        = '--openmp',
        clone_build_out = clone_build_out,
        clone_build_err = clone_build_err         )

musubi_omp = clone_build( solver          = 'musubi',
        hg_clone_source = hg_clone_source+'musubi',
        solver_dir      = 'musubi',
        confopts        = '--openmp',
        clone_build_out = clone_build_out,
        clone_build_err = clone_build_err         )

################################################################################
#                                                                              #
#                Testcases for scheme kind: fluid                              #
#                                                                              #
################################################################################
### Path to fluid testcases
fluid = musubi_test+'fluid/'


#//////////////////////////////////////////////////////////////////////////////#
#                   Testcases tree: fluid/benchmark                            #
#//////////////////////////////////////////////////////////////////////////////#
### Path to fluid benchmark testcases
fluid_bench = fluid+'benchmark/'


#------------------------------------------------------------------------------#
### start gaussianPulse testcase
testcase_path = fluid_bench+'gaussianPulse/'
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    prefix = 'gaussianPulse',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 2',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    create_dir = True,
    label = 'gaussianPulse_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'reference/gaussianPulse_pressAlongLength_p00000_t50.000E+00.res',
    val_output_filename = 'tracking/gaussianPulse_pressAlongLength_p00000_t50.000E+00.res',
    ))
### end gaussianPulse testcase
#------------------------------------------------------------------------------#


#==============================================================================#
#                Testcases tree: fluid/benchmark/channel2D                     #
#==============================================================================#
### Path to fluid benchmark channel2D testcases
fluid_bench_C2D = fluid_bench+'/channel2D/'


#------------------------------------------------------------------------------#
### start Plain channel 2D
testcase_path = fluid_bench_C2D+'C2D_Simple/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_Simple',
    label = 'C2D_Simple_seeder',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['C2D_Simple_seeder'],
    create_dir = False,
    label = 'C2D_Simple_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    position = [0,4],
    val_ref_path = testcase_path+'tracking/ref_channel_pressAlongLength_p00000_t42.403E+00.res',
    val_output_filename = 'tracking/channel_pressAlongLength_p00000_t42.403E+00.res',
    ))
### end Plain channel 2D
#------------------------------------------------------------------------------#


#==============================================================================#
#        Testcases tree: fluid/benchmark/channel2D/C2D_BoundaryConditions      #
#==============================================================================#
### Path to fluid benchmark C2D_BoundaryConditions testcases
fluid_bench_C2D_BC = fluid_bench_C2D+'C2D_BoundaryConditions/'


#------------------------------------------------------------------------------#
### start C2D_BC_MfrBB_PressExpol
testcase_path = fluid_bench_C2D_BC+'C2D_BC_MfrBB_PressExpol/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_frBB_PressExpol',
    label = 'seeder_frBB_PressExpol',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 14',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_frBB_PressExpol'],
    create_dir = False,
    label = 'BC_MfrBB_PressExpol_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t11.896E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t11.896E+00.res',
    ))
### end C2D_BC_MfrBB_PressExpol
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start C2D_BC_MfrEq_PressEq
testcase_path = fluid_bench_C2D_BC+'C2D_BC_MfrEq_PressEq/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_BC_MfrEq_PressEq',
    label = 'seeder_C2D_BC_MfrEq_PressEq',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 12',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_C2D_BC_MfrEq_PressEq'],
    create_dir = False,
    label = 'C2D_BC_MfrEq_PressEq_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t21.351E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t21.351E+00.res',
    ))
### end C2D_BC_MfrEq_PressEq
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start C2D_BC_PressExpol_PressExpol
testcase_path = fluid_bench_C2D_BC+'C2D_BC_PressExpol_PressExpol/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_BC_PressExpol_PressExpol',
    label = 'seeder_C2D_BC_PressExpol_PressExpol',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 15',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_C2D_BC_PressExpol_PressExpol'],
    create_dir = False,
    label = 'C2D_BC_PressExpol_PressExpol_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t33.501E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t33.501E+00.res',
    ))
### end C2D_BC_PressExpol_PressExpol
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start C2D_BC_VelBB_PressExpol
testcase_path = fluid_bench_C2D_BC+'C2D_BC_VelBB_PressExpol/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_BC_VelBB_PressExpol',
    label = 'seeder_C2D_BC_VelBB_PressExpol',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 11',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_C2D_BC_VelBB_PressExpol'],
    create_dir = False,
    label = 'C2D_BC_VelBB_PressExpol_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t21.148E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t21.148E+00.res',
    ))
### end C2D_BC_VelBB_PressExpol
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start C2D_BC_VelBFL_PressExpol
testcase_path = fluid_bench_C2D_BC+'C2D_BC_VelBFL_PressExpol/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_BC_VelBFL_PressExpol',
    label = 'seeder_C2D_BC_VelBFL_PressExpol',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 13',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_C2D_BC_VelBFL_PressExpol'],
    create_dir = False,
    label = 'C2D_BC_VelBFL_PressExpol_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t21.148E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t21.148E+00.res',
    ))
### end C2D_BC_VelBFL_PressExpol
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start C2D_BC_VelEq_PressEq
testcase_path = fluid_bench_C2D_BC+'C2D_BC_VelEq_PressEq/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_BC_VelEq_PressEq',
    label = 'seeder_C2D_BC_VelEq_PressEq',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 10',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_C2D_BC_VelEq_PressEq'],
    create_dir = False,
    label = 'C2D_BC_VelEq_PressEq_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t21.440E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t21.440E+00.res',
    ))
### end C2D_BC_VelEq_PressEq
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start C2D_BC_VelNonEqExpol_PressNonEqExpol
testcase_path = fluid_bench_C2D_BC+'C2D_BC_VelNonEqExpol_PressNonEqExpol/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'C2D_BC_VelNonEqExpol_PressNonEqExpol',
    label = 'seeder_C2D_BC_VelNonEqExpol_PressNonEqExpol',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 16',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['seeder_C2D_BC_VelNonEqExpol_PressNonEqExpol'],
    create_dir = False,
    label = 'C2D_BC_VelNonEqExpol_PressNonEqExpol_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
#  comparing differenc to analytical soultion
    val_ref_path = testcase_path+'reference/channel_DiffAlongHeight_p00000_t21.304E+00.res',
    val_output_filename = 'tracking/channel_DiffAlongHeight_p00000_t21.304E+00.res',
    ))
### end C2D_BC_VelNonEqExpol_PressNonEqExpol
#------------------------------------------------------------------------------#






################################################################################
#                                                                              #
#                Testcases for scheme kind: fluid_incompressible               #
#                                                                              #
################################################################################
### Path to fluid incompressible testcases
fluid_incomp = musubi_test+'fluid_incompressible/'


#//////////////////////////////////////////////////////////////////////////////#
#               Testcases tree: fluid_incompressible/benchmark                 #
#//////////////////////////////////////////////////////////////////////////////#
### Path to fluid_incompressible benchmark testcases
fluid_incomp_bench = fluid_incomp+'benchmark/'


#------------------------------------------------------------------------------#
### start gaussianPulse_incomp
testcase_path = fluid_incomp_bench+'gaussianPulse/'
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    prefix = 'gaussianPulse_incomp',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 6',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    create_dir = True,
    label = 'gaussianPulse_incomp',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'reference/gaussianPulse_pressAlongLength_p00001_t50.000E+00.res',
    val_output_filename = 'tracking/gaussianPulse_pressAlongLength_p00001_t50.000E+00.res',
    ))
### end gaussianPulse_incomp
#------------------------------------------------------------------------------#


#==============================================================================#
#        Testcases tree: fluid_incompressible/benchmark/TaylorGreenVortex      #
#==============================================================================#
### Path to fluid_incompressible benchmark TaylorGreenVortex testcases
fluid_incomp_bench_TGV = fluid_incomp_bench +'TaylorGreenVortex/'


#------------------------------------------------------------------------------#
### start TGV_Simple
testcase_path = fluid_incomp_bench_TGV+'TGV_Simple/'
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    prefix = 'TGV_Simple',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 12',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    create_dir = True,
    label = 'TGV_Simple',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'reference/TGV_Simple_probeAtCenter_p00000.res',
    val_output_filename = 'tracking/TGV_Simple_probeAtCenter_p00000.res',
    ))
### end TGV_Simple
#------------------------------------------------------------------------------#


#==============================================================================#
#            Testcases tree: fluid_incompressible/benchmark/Channel2D          #
#==============================================================================#
### Path to fluid_incompressible benchmark Channel2D testcases
fluid_incomp_bench_C2D = fluid_incomp_bench+'Channel2D/'


#------------------------------------------------------------------------------#
### start Channel 2D with cylinder single level
testcase_path = fluid_incomp_bench_C2D+'C2D_Cylinder_SingleLevel/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(stl_path = testcase_path),
    create_subdir = ['mesh'],
    prefix = 'C2D_Cyl_SL_Incomp',
    label = 'C2D_Cyl_SL_Incomp_seeder',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 4',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['C2D_Cyl_SL_Incomp_seeder'],
    create_dir = False,
    label = 'C2D_Cyl_SL_Incomp_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'tracking/ref_channel_cyl_force_p00000.res',
    val_output_filename = 'tracking/channel_cyl_force_p00000.res',
    ))
### end Channel 2D with cylinder single level
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
## start Channel 2D with cylinder multilevel
testcase_path = fluid_incomp_bench_C2D+'C2D_Cylinder_MultiLevel/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(stl_path = testcase_path),
    create_subdir = ['mesh'],
    prefix = 'C2D_Cyl_ML_Incomp',
    label = 'C2D_Cyl_ML_Incomp_seeder',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 8',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['C2D_Cyl_ML_Incomp_seeder'],
    create_dir = False,
    label = 'C2D_Cyl_ML_Incomp_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'reference/channel_cyl_force_p00000.res',
    val_output_filename = 'tracking/channel_cyl_force_p00000.res',
    ))
### end Channel 2D with cylinder multilevel
#------------------------------------------------------------------------------#


#==============================================================================#
#            Testcases tree: fluid_incompressible/benchmark/Channel3D          #
#==============================================================================#
### Path to fluid_incompressible benchmark Channel3D testcases
fluid_incomp_bench_C3D = fluid_incomp_bench+'Channel3D/'


#------------------------------------------------------------------------------#
### start Channel 3D simple with nonEqExpol BCs
testcase_path = fluid_incomp_bench_C3D+'C3D_Simple/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(stl_path = testcase_path),
    create_subdir = ['mesh'],
    prefix = 'C3D_Simple',
    label = 'C3D_Simple_Incomp_seeder',
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 12',
    additional_params = dict(testcase_path = testcase_path),
    create_subdir = ['tracking','restart'],
    depend = ['C3D_Simple_Incomp_seeder'],
    create_dir = False,
    label = 'C3D_Simple_Incomp_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'reference/C3D_Simple_ref_velAlongHeight_p00000_t10.000E+00.res',
    val_output_filename = 'tracking/C3D_Simple_velAlongHeight_p00000_t10.000E+00.res',
    ))
### end Channel 3D simple with nonEqExpol BCs
#------------------------------------------------------------------------------#


#==============================================================================#
#        Testcases tree: fluid_incompressible/benchmark/LidDrivenCavity        #
#==============================================================================#
### Path to fluid_incompressible benchmark LidDrivenCavity testcases
fluid_incomp_bench_LDC = fluid_incomp_bench+'LidDrivenCavity/'


#------------------------------------------------------------------------------#
### start Lid-Driven Cavity 2D fluid_incompressible model
testcase_path = fluid_incomp_bench_LDC+'LDC_Simple/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    create_subdir = ['mesh'],
    prefix = 'LDC_Simple_Incomp',
    label = 'LDC_Simple_Incomp_seeder',
    attachment = True,
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 8',
    create_subdir = ['tracking','restart'],
    depend = ['LDC_Simple_Incomp_seeder'],
    create_dir=False,
    label = 'LDC_Simple_Incomp_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'tracking/ref_lidcavity_probe_p00000.res',
    val_output_filename = 'tracking/lidcavity_probe_p00000.res',
    ))
### end Lid-Driven Cavity 2D fluid_incompressible model
#------------------------------------------------------------------------------#


#==============================================================================#
#              Testcases tree: fluid_incompressible/benchmark/Pipe             #
#==============================================================================#
### Path to fluid_incompressible benchmark Pipe testcases
fluid_incomp_bench_pipe = fluid_incomp_bench+'Pipe/'


#------------------------------------------------------------------------------#
### start Pipe flow with pressure-pressure BC fluid_incompressible model
testcase_path = fluid_incomp_bench_pipe+'PIP_Simple/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(stl_path = testcase_path),
    create_subdir = ['mesh'],
    prefix = 'PIP_Simple_Incomp',
    label = 'PIP_Simple_Incomp_seeder',
    attachment = True,
    ))

shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 8',
    create_subdir = ['tracking','restart'],
    depend = ['PIP_Simple_Incomp_seeder'],
    create_dir=False,
    label = 'PIP_Simple_Incomp_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'tracking/ref_pipe_probeAtCenter_p00000.res',
    val_output_filename = 'tracking/pipe_probeAtCenter_p00000.res',
    ))
### end Pipe flow with pressure-pressure BC fluid_incompressible model
#------------------------------------------------------------------------------#


################################################################################
#                                                                              #
#                       Testcases for tutorial                                 #
#                                                                              #
################################################################################
tutorial_test = musubi_test + 'tutorials/tutorial_cases/'

#------------------------------------------------------------------------------#
### start tutorial Pip_force testcase
testcase_path = tutorial_test +'tutorial_PIP_Force/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(stl_path = testcase_path),
    create_subdir = ['mesh'],
    prefix = 'tut_pip',
    label = 'tut_pip_seeder',
    attachment = True,
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 4',
    create_subdir = ['tracking','restart'],
    depend = ['tut_pip_seeder'],
    create_dir=False,
    label = 'tut_pip_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'ref/pipe_probeAtCenter_p00000.res',
    val_output_filename = 'tracking/pipe_probeAtCenter_p00000.res',
    ))
### end tutorial Pip_force testcase
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start tutorial gaussian_pulse testcase
testcase_path = tutorial_test +'tutorial_gaussian_pulse/'
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 1',
    create_subdir = ['tracking','restart'],
    create_dir=True,
    label = 'tut_gauss_pulse',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'ref/Gausspulse_track_pressure_p00000.res',
    val_output_filename = 'tracking/Gausspulse_track_pressure_p00000.res',
    ))
### end tutorial gaussian_pulse testcase
#------------------------------------------------------------------------------#

#------------------------------------------------------------------------------#
### start tutorial channel testcase
testcase_path = tutorial_test +'tutorial_channelGeneric/'
shepherd_jobs.append(dict(executable = seeder_exe,
    template=testcase_path+'seeder.lua',
    extension='lua',
    run_exec = True,
    additional_params = dict(stl_path = testcase_path),
    create_subdir = ['mesh'],
    prefix = 'tut_channel',
    label = 'tut_channel_seeder',
    attachment = True,
    ))
shepherd_jobs.append(dict(executable = musubi_exe,
    solver_name = 'musubi',
    template=testcase_path+'musubi.lua',
    extension='lua',
    run_exec = True,
    run_command = 'mpirun -np 8',
    create_subdir = ['tracking','restart'],
    depend = ['tut_channel_seeder'],
    create_dir=False,
    label = 'tut_channel_musubi',
    attachment = True,
    validation = True,
    val_method = 'difference',
    val_ref_path = testcase_path+'ref/channel_probeAtCenter_p00000.res',
    val_output_filename = 'tracking/channel_probeAtCenter_p00000.res',
    ))
### end tutorial channel testcase
#------------------------------------------------------------------------------#
