! Copyright (c) 2015-2016 Jiaxing Qi <jiaxing.qi@uni-siegen.de>
! Copyright (c) 2016 Tobias Schneider <tobias1.schneider@student.uni-siegen.de>
! Copyright (c) 2020 Peter Vitt <peter.vitt2@uni-siegen.de>
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!
! 1. Redistributions of source code must retain the above copyright notice,
! this list of conditions and the following disclaimer.
!
! 2. Redistributions in binary form must reproduce the above copyright notice,
! this list of conditions and the following disclaimer in the documentation
! and/or other materials provided with the distribution.
!
! THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY OF SIEGEN “AS IS” AND ANY EXPRESS
! OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
! OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
! IN NO EVENT SHALL UNIVERSITY OF SIEGEN OR CONTRIBUTORS BE LIABLE FOR ANY
! DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
! (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
! LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
! ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
! (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
! SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

?? text :: vel_d3q19( u_x, u_y, u_z, f, inv_rho )
    ?u_x? =   ?f?(18) + ?f?(17) + ?f?( 4) &
      &     + ?f?(14) + ?f?(12)           &
      &     - ?f?(16) - ?f?( 1) - ?f?(15) &
      &     - ?f?(13) - ?f?(11)

    ?u_y? =   ?f?(18) + ?f?( 5) + ?f?(16) &
      &     + ?f?(10) + ?f?( 9)           &
      &     - ?f?(15) - ?f?( 2) - ?f?(17) &
      &     - ?f?( 8) - ?f?( 7)

    ?u_z? =   ?f?( 6) + ?f?(14) + ?f?(10) &
      &     + ?f?(13) + ?f?( 8)           &
      &     - ?f?( 3) - ?f?(12) - ?f?( 9) &
      &     - ?f?(11) - ?f?( 7)

    ?u_x? = ?u_x? * ?inv_rho?
    ?u_y? = ?u_y? * ?inv_rho?
    ?u_z? = ?u_z? * ?inv_rho?
?? end text vel_d3q19


?? text :: fEq_d3q19_a( fEq, u_x, u_y, u_z, rho, rho0 )
  usq  = ?u_x?*?u_x? + ?u_y?*?u_y? + ?u_z?*?u_z?
  usqn = div1_36 * (?rho? - 1.5d0 * usq * ?rho0?)

  ?fEq?(19) = 12.0d0 * usqn

  coeff_1 = 0.125d0 * ?rho0?

  ui1     =  ?u_x? + ?u_y?
  fac_1   = coeff_1 * ui1
  sum1_1  = fac_1 * div3_4h
  sum1_2  = fac_1 * ui1 + usqn

  ?fEq?(18) =  sum1_1 +sum1_2
  ?fEq?(15) = -sum1_1 +sum1_2

  ui3     = -?u_x? + ?u_y?
  fac_3   = coeff_1 * ui3
  sum3_1  = fac_3 * div3_4h
  sum3_2  = fac_3 * ui3 + usqn

  ?fEq?(16) =  sum3_1 +sum3_2
  ?fEq?(17) = -sum3_1 +sum3_2

  ui10    =  ?u_x? + ?u_z?
  fac_10  = coeff_1 * ui10
  sum10_1 = fac_10 * div3_4h
  sum10_2 = fac_10 * ui10 + usqn

  ?fEq?(14) =  sum10_1+sum10_2
  ?fEq?(11) = -sum10_1+sum10_2

  ui12    = -?u_x? + ?u_z?
  fac_12  = coeff_1 * ui12
  sum12_1 = fac_12 * div3_4h
  sum12_2 = fac_12 * ui12 + usqn

  ?fEq?(13) =  sum12_1+sum12_2
  ?fEq?(12) = -sum12_1+sum12_2

  ui11    =  ?u_y? + ?u_z?
  fac_11  = coeff_1 * ui11
  sum11_1 = fac_11 * div3_4h
  sum11_2 = fac_11 * ui11 + usqn

  ?fEq?(10) =  sum11_1+sum11_2
  ?fEq?( 7) = -sum11_1+sum11_2

  ui13    = -?u_y? + ?u_z?
  fac_13  = coeff_1 * ui13
  sum13_1 = fac_13 * div3_4h
  sum13_2 = fac_13 * ui13 + usqn

  ?fEq?( 8) =  sum13_1+sum13_2
  ?fEq?( 9) = -sum13_1+sum13_2

  coeff_2 = 0.25d0 * ?rho0?
  usqn_o2 = 2.0d0 * usqn

  fac_2   = coeff_2 * ?u_y?
  sum2_1  = fac_2 * div3_4h
  sum2_2  = fac_2 * ?u_y? + usqn_o2

  ?fEq?( 5) =  sum2_1 +sum2_2
  ?fEq?( 2) = -sum2_1 +sum2_2

  fac_4   = coeff_2 * ?u_x?
  sum4_1  = fac_4 * div3_4h
  sum4_2  = fac_4 * ?u_x? + usqn_o2

  ?fEq?( 1) = -sum4_1 +sum4_2
  ?fEq?( 4) =  sum4_1 +sum4_2

  fac_9   = coeff_2 * ?u_z?
  sum9_1  = fac_9 * div3_4h
  sum9_2  = fac_9 * ?u_z? + usqn_o2

  ?fEq?( 6) =  sum9_1 +sum9_2
  ?fEq?( 3) = -sum9_1 +sum9_2

?? end text fEq_d3q19_a
