// Matrixoperation.h : matrixcalculation
// Autor: majo (majo02@avt.rwth-aachen.de), thbe (thbe02@avt.rwth-aachen.de)
// UML-Diagramm:
// -
// Quellen:
// [1] Pack, R., 2011; Development of a Computational Routine for Estimation
//     of Activity Coefficents in Electrolyte Systems, Studienarbeit, AVT.PT
// [2] Mathias, P.M., 2004; Correlation for the Density of Multicomponent 
//	   Aqueous Electrolytes, Ind. Eng. Chem. Res. 2004, 43, p.: 6247-6252

#include "Matrixoperation.h"

using namespace std;

Matrixoperation::Matrixoperation(){}

Matrixoperation::Matrixoperation(bool Ausgabe){
	MatrixoperationInitialized = true;
	
	if(Ausgabe){
		if(MatrixoperationInitialized){
			cout<<">> Initialisierung von Matrixoperation \t [erfolgreich]"<<endl<<endl;
		}else{
			cout<<">> Initialisierung von Matrixoperation \t [FEHLER]"<<endl<<endl;
		}
	}
}

void Matrixoperation::copy_5_3_array(double source[5][3], double target[5][3])
{
	for(int i = 0; i < 5; i++)
	{
		for(int j = 0; j < 3; j++)
		{
			target[i][j] = source[i][j];
		}
	}
}

void Matrixoperation::Eval_4_species(double **DK, double *V, double *z, double *c , double VE, double *EigenValues)
{
	EigenValues[0] =  (-DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[0] * DK[1][2] * DK[3][2] * V[0] - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[0] * DK[1][2] * DK[3][2] * VE - DK[0][1] * DK[2][1] * DK[3][1] * pow(c[1], 0.2e1) * z[3] * DK[0][2] * DK[3][2] * V[0] - DK[0][1] * DK[2][1] * DK[3][1] * pow(c[1], 0.2e1) * z[3] * DK[0][2] * DK[3][2] * VE - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[3] * DK[0][2] * DK[1][2] * V[0] - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[3] * DK[0][2] * DK[1][2] * VE - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[2] * DK[1][2] * DK[3][2] * c[2] * V[0] - 0.2e1 * DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[2] * DK[1][2] * DK[3][2] * c[2] * VE - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * DK[1][2] * DK[3][2] * c[2] * z[3] * V[2] - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * DK[1][2] * DK[3][2] * c[2] * z[3] * VE - DK[0][1] * DK[2][1] * DK[3][1] * c[1] * DK[1][2] * DK[3][2] * c[2] * z[2] * V[3] - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[0] * DK[2][1] * DK[3][1] * V[0] - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[0] * DK[2][1] * DK[3][1] * VE - DK[0][2] * DK[1][2] * DK[3][2] * pow(c[2], 0.2e1) * z[3] * DK[0][1] * DK[3][1] * V[0] - DK[0][2] * DK[1][2] * DK[3][2] * pow(c[2], 0.2e1) * z[3] * DK[0][1] * DK[3][1] * VE - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[3] * DK[0][1] * DK[2][1] * V[0] - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[3] * DK[0][1] * DK[2][1] * VE - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[1] * DK[2][1] * DK[3][1] * c[1] * V[0] - 0.2e1 * DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[1] * DK[2][1] * DK[3][1] * c[1] * VE - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * DK[2][1] * DK[3][1] * c[1] * z[3] * V[1] - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * DK[2][1] * DK[3][1] * c[1] * z[3] * VE - DK[0][2] * DK[1][2] * DK[3][2] * c[2] * DK[2][1] * DK[3][1] * c[1] * z[1] * V[3] + sqrt(pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * pow(z[3], 0.2e1) * VE + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * z[2] * VE - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * pow(z[3], 0.2e1) * VE + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * z[1] * VE * z[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[1][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(V[0], 0.2e1) * c[3] * DK[0][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * DK[3][2] * V[0] * c[3] * DK[0][2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * c[2] + 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * z[2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * c[2] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * pow(c[2], 0.2e1) - 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * pow(c[2], 0.2e1) * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * c[2] * c[3] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * c[2] * z[1] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[1][2] * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * DK[3][2] * VE * VE * c[3] * DK[0][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * z[2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * pow(c[2], 0.2e1) - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] * c[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] * z[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[0][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[0][2] * c[2] * z[1] * V[3] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[3][2] * pow(V[0], 0.2e1) * c[3] * DK[1][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[3][2] * V[0] * c[3] * DK[1][2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * DK[1][2] * c[2] + 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * z[2] * DK[1][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * c[2] * c[0] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * c[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * pow(c[2], 0.2e1) + 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * pow(c[2], 0.2e1) * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * c[2] * c[3] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * c[2] * z[1] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[3][2] * VE * VE * c[3] * DK[1][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * VE * z[2] * DK[1][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] * c[0] + 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * pow(c[2], 0.2e1) - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] * c[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] * z[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * DK[3][2] * c[2] + 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * z[2] * DK[3][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * c[2] * c[0] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) - 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * pow(c[2], 0.2e1) * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * c[2] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * c[2] * z[1] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * VE * z[2] * DK[3][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] * c[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * pow(c[2], 0.2e1) - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] * z[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * z[3] * c[0] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(V[0], 0.2e1) * DK[0][2] * z[3] - 0.6e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * V[0] * DK[0][2] * z[3] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * z[3] * c[3] - 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * z[1] - 0.8e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * VE - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[1] * V[3] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * z[3] * V[2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[3] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * DK[0][2] * z[3] * c[0] - 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * VE * VE * DK[0][2] * z[3] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * DK[0][2] * z[3] * c[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * DK[0][2] * z[1] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(V[2], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * V[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[0] * V[0] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * V[2] * DK[0][2] * z[1] * V[0] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * V[1] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * VE + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * V[2] * DK[0][2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * VE * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * c[0] * V[0] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] * c[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * c[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] * c[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * VE * DK[0][2] * z[1] * V[0] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * V[1] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * VE * DK[0][2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[2], 0.2e1) * pow(V[3], 0.2e1) - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[0] * V[0] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[2] * V[3] * DK[0][2] * z[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[2] * V[3] * DK[0][2] * z[3] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[3] * VE + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * V[1] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * VE + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * pow(V[3], 0.2e1) * DK[0][2] * z[1] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) * DK[0][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[2][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[0][1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(V[0], 0.2e1) * c[3] * DK[0][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * DK[3][1] * V[0] * c[3] * DK[0][1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) * z[1] * c[1] + 0.6e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * z[1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[2][1] * pow(DK[3][1], 0.2e1) * VE * VE * DK[0][1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * DK[3][1] * VE * VE * c[3] * DK[0][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE * z[1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[3][1] * pow(V[0], 0.2e1) * c[3] * DK[2][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[3][1] * V[0] * c[3] * DK[2][1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) * z[1] * DK[2][1] * c[1] + 0.6e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * z[1] * DK[2][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[2][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[2][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[2][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[3][1] * VE * VE * c[3] * DK[2][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * VE * z[1] * DK[2][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * DK[2][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * VE * DK[2][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * DK[2][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(V[0], 0.2e1) * z[1] * DK[3][1] * c[1] + 0.6e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * z[1] * DK[3][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * DK[3][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * DK[3][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * DK[3][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * VE * z[1] * DK[3][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * DK[3][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * VE * DK[3][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * DK[3][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(V[0], 0.2e1) + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * z[3] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * z[3] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * V[3] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * z[3] * V[1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * VE * z[3] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(V[1], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * V[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * V[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * VE * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[1], 0.2e1) * pow(V[3], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * VE * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * z[1] * VE * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[1] * z[3] * VE + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[1] * z[2] * VE - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] * z[2] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * V[2] * z[1] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[1] * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * z[1] * z[2] - 0.8e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * VE * z[2] * z[3] - 0.8e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * VE * z[1] * z[3] + 0.8e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[1] * pow(z[3], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[2] * pow(z[3], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * pow(z[3], 0.2e1) + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[3] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * pow(z[3], 0.2e1) + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[3] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] * z[2] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * V[2] * z[1] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[1] * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[1] * pow(z[3], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[2] * pow(z[3], 0.2e1))) / c[1] / DK[3][1] / DK[2][1] / DK[0][1] / DK[0][2] / DK[1][2] / DK[3][2] / c[2] / (V[0] + VE) / z[3] / 0.2e1;
	
	

	EigenValues[1] = - (DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[0] * DK[1][2] * DK[3][2] * V[0] + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[0] * DK[1][2] * DK[3][2] * VE + DK[0][1] * DK[2][1] * DK[3][1] * pow(c[1], 0.2e1) * z[3] * DK[0][2] * DK[3][2] * V[0] + DK[0][1] * DK[2][1] * DK[3][1] * pow(c[1], 0.2e1) * z[3] * DK[0][2] * DK[3][2] * VE + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[3] * DK[0][2] * DK[1][2] * V[0] + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[3] * c[3] * DK[0][2] * DK[1][2] * VE + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[2] * DK[1][2] * DK[3][2] * c[2] * V[0] + 0.2e1 * DK[0][1] * DK[2][1] * DK[3][1] * c[1] * z[2] * DK[1][2] * DK[3][2] * c[2] * VE + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * DK[1][2] * DK[3][2] * c[2] * z[3] * V[2] + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * DK[1][2] * DK[3][2] * c[2] * z[3] * VE + DK[0][1] * DK[2][1] * DK[3][1] * c[1] * DK[1][2] * DK[3][2] * c[2] * z[2] * V[3] + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[0] * DK[2][1] * DK[3][1] * V[0] + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[0] * DK[2][1] * DK[3][1] * VE + DK[0][2] * DK[1][2] * DK[3][2] * pow(c[2], 0.2e1) * z[3] * DK[0][1] * DK[3][1] * V[0] + DK[0][2] * DK[1][2] * DK[3][2] * pow(c[2], 0.2e1) * z[3] * DK[0][1] * DK[3][1] * VE + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[3] * DK[0][1] * DK[2][1] * V[0] + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[3] * c[3] * DK[0][1] * DK[2][1] * VE + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[1] * DK[2][1] * DK[3][1] * c[1] * V[0] + 0.2e1 * DK[0][2] * DK[1][2] * DK[3][2] * c[2] * z[1] * DK[2][1] * DK[3][1] * c[1] * VE + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * DK[2][1] * DK[3][1] * c[1] * z[3] * V[1] + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * DK[2][1] * DK[3][1] * c[1] * z[3] * VE + DK[0][2] * DK[1][2] * DK[3][2] * c[2] * DK[2][1] * DK[3][1] * c[1] * z[1] * V[3] + sqrt(-0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] * z[2] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * V[3] * z[1] * z[2] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[1][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(V[0], 0.2e1) * c[3] * DK[0][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * DK[3][2] * V[0] * c[3] * DK[0][2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * c[2] + 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * z[2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * c[2] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * pow(c[2], 0.2e1) - 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * pow(c[2], 0.2e1) * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * c[2] * c[3] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * c[2] * z[1] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[0][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[1][2] * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * DK[3][2] * VE * VE * c[3] * DK[0][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * z[2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * pow(c[2], 0.2e1) - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] * c[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] * z[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[0][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[0][2] * c[2] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[0] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[0][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[3][2] * pow(V[0], 0.2e1) * c[3] * DK[1][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[3][2] * V[0] * c[3] * DK[1][2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * DK[1][2] * c[2] + 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * z[2] * DK[1][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * c[2] * c[0] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * c[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * pow(c[2], 0.2e1) + 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * pow(c[2], 0.2e1) * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * c[2] * c[3] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(V[0], 0.2e1) * DK[1][2] * c[2] * z[1] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * V[0] * DK[1][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[3][2] * VE * VE * c[3] * DK[1][2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * VE * z[2] * DK[1][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * DK[0][2] * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] * c[0] + 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * pow(c[2], 0.2e1) - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] * c[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] * z[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * VE * DK[1][2] * c[2] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.3e1) * z[3] * pow(DK[0][2], 0.2e1) * pow(DK[3][2], 0.2e1) * VE * DK[1][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * DK[3][2] * c[2] + 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * z[2] * DK[3][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * c[2] * c[0] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) - 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * pow(c[2], 0.2e1) * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * c[2] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(V[0], 0.2e1) * DK[3][2] * c[2] * z[1] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * V[0] * DK[3][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * VE * z[2] * DK[3][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * DK[0][2] * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] * c[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * pow(c[2], 0.2e1) - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] * z[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * VE * DK[3][2] * c[2] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * c[3] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * VE * DK[3][2] * c[2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * V[2] + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * z[3] * c[0] - 0.6e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(V[0], 0.2e1) * DK[0][2] * z[3] - 0.6e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * V[0] * DK[0][2] * z[3] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * z[3] * c[3] - 0.6e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * DK[0][2] * z[1] - 0.8e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[1] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * V[1] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[3] * VE - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * DK[0][2] * z[1] * V[3] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * z[3] * V[2] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[3] + 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * DK[0][2] * z[3] * c[0] - 0.4e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * VE * VE * DK[0][2] * z[3] - 0.4e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * DK[0][2] * z[3] * c[3] - 0.4e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * DK[0][2] * z[1] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(V[2], 0.2e1) + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * V[2] * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[0] * V[0] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * c[3] * VE - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * V[2] * DK[0][2] * z[1] * V[0] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * V[1] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * V[2] * DK[0][2] * VE + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * V[2] * DK[0][2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * VE * z[2] * V[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * c[0] * V[0] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] * c[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * c[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] * c[3] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * VE * DK[0][2] * z[1] * V[0] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * DK[0][2] * V[1] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * VE * VE * DK[0][2] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * VE * DK[0][2] * z[1] * V[3] + pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[2], 0.2e1) * pow(V[3], 0.2e1) - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[0] * V[0] - 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[0] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[2] * V[3] * DK[0][2] * z[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * DK[2][1] * pow(DK[3][1], 0.2e1) * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[2] * V[3] * DK[0][2] * z[3] * VE - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[3] * V[0] - 0.2e1 * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[3][1] * c[1] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * c[3] * VE + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * V[1] + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * V[3] * DK[0][2] * z[3] * VE + 0.2e1 * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[2] * pow(V[3], 0.2e1) * DK[0][2] * z[1] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[2][1] * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) * DK[0][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[2][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[0][1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * DK[3][1] * pow(V[0], 0.2e1) * c[3] * DK[0][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * DK[3][1] * V[0] * c[3] * DK[0][1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) * z[1] * c[1] + 0.6e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * z[1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[0], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * c[0] * DK[2][1] * pow(DK[3][1], 0.2e1) * VE * VE * DK[0][1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * DK[3][1] * VE * VE * c[3] * DK[0][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE * z[1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[0] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[3][1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[3][1] * pow(V[0], 0.2e1) * c[3] * DK[2][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[3][1] * V[0] * c[3] * DK[2][1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * pow(V[0], 0.2e1) * z[1] * DK[2][1] * c[1] + 0.6e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * z[1] * DK[2][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[2][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[2][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * V[0] * DK[2][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.4e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[3][1], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[3][1] * VE * VE * c[3] * DK[2][1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * VE * z[1] * DK[2][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * DK[2][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * pow(z[3], 0.2e1) * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * VE * DK[2][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.3e1) * z[3] * DK[0][1] * pow(DK[3][1], 0.2e1) * VE * DK[2][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(V[0], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * pow(V[0], 0.2e1) * z[1] * DK[3][1] * c[1] + 0.6e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * z[1] * DK[3][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * DK[3][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * DK[3][1] * c[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * V[0] * DK[3][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * pow(c[3], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[2][1], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * VE * z[1] * DK[3][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * DK[3][1] * c[1] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[3], 0.2e1) * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * VE * DK[3][1] * c[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[3] * c[3] * DK[0][1] * pow(DK[2][1], 0.2e1) * VE * DK[3][1] * c[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(V[0], 0.2e1) + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * z[3] * V[1] + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * z[3] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * V[0] * V[3] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * VE + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * z[3] * V[1] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * z[1] * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * VE * z[3] + 0.4e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(z[1], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * VE * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * pow(V[1], 0.2e1) + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * V[1] * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * V[1] * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[3], 0.2e1) * VE * VE + 0.2e1 * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * z[3] * VE * z[1] * V[3] + pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(DK[2][1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(c[1], 0.2e1) * pow(z[1], 0.2e1) * pow(V[3], 0.2e1) + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * V[2] * z[1] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[1] * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * pow(V[0], 0.2e1) * z[1] * z[2] - 0.8e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * VE * z[2] * z[3] - 0.8e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * VE * z[1] * z[3] + 0.8e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[2] * pow(z[3], 0.2e1) + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * z[2] * VE - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * pow(z[3], 0.2e1) * VE + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * z[1] * VE * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * pow(z[3], 0.2e1) * VE - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[3] * VE * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * V[0] * z[1] * VE * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[1] * z[3] * VE + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * z[1] * z[2] * VE - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * V[0] * V[1] * pow(z[3], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] * z[2] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * V[2] * z[1] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[3] * z[1] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[1] * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[2] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[2] * pow(z[3], 0.2e1) + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[3] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * pow(z[3], 0.2e1) + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[3] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * pow(z[3], 0.2e1) - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * DK[1][2] * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[3] * z[2] + 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * pow(DK[2][1], 0.2e1) * DK[0][1] * pow(DK[0][2], 0.2e1) * pow(DK[1][2], 0.2e1) * DK[3][2] * pow(c[2], 0.2e1) * VE * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[1] * z[3] + 0.4e1 * pow(c[1], 0.2e1) * DK[3][1] * pow(DK[2][1], 0.2e1) * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * VE * z[1] * z[2] - 0.4e1 * pow(c[1], 0.2e1) * pow(DK[3][1], 0.2e1) * DK[2][1] * pow(DK[0][1], 0.2e1) * DK[0][2] * pow(DK[1][2], 0.2e1) * pow(DK[3][2], 0.2e1) * pow(c[2], 0.2e1) * VE * V[1] * pow(z[3], 0.2e1))) / c[1] / DK[3][1] / DK[2][1] / DK[0][1] / DK[0][2] / DK[1][2] / DK[3][2] / c[2] / (V[0] + VE) / z[3] / 0.2e1;

	printf("\n Zeile 6643: Eigenvalue1: %16.10f !!!", EigenValues[0] );
	printf("\n Zeile 6643: Eigenvalue2: %16.10f !!!", EigenValues[1] );

	EigenValues[0] = 1;
	EigenValues[1] = 1;

}