require 'musubi'

print('-----------------------------------------------------------------------')
print('Simulation name: ', simulation_name)
print('-----------------------------------------------------------------------')
print('------Mesh parameters------'     )
print('length       =', length          )
print('height       =', length          )
print('width        =', length          )
print('level        =', refinementLevel )
print('-----Number of elements----'     )
print('in height    =', length/dx       )
print('in width     =', length/dx       )
print('in length    =', length/dx       )
print('--------Resolution---------'     )
print('Element size (dx) =', dx,  '[m]' )
print('Time step (dt)    =', dt,  '[s]' )
print('-----------------------------------------------------------------------')
print('------Flow parameters------'                  )
print('------In physical units----'                  )
print('Re                =', Re                      )
print('Vel. max.         =', vel_max_phy,  '[m/s]'   )
print('Kinematic visc.   =', nu_phy,       '[m^s/2]' )
print('Density           =', rho0_phy,     '[kg/m^3]')
print('Press. ambient    =', press_ambient,'[N/m^2]' )
print('------In lattice units-----' )
print('Vel.              =', vel_lat)
print('Ma                =', Ma_lat )
-- Lattice viscosity
nu_lat = nu_phy * dt / dx^2
print('Kinematic lattice visc. =', nu_lat)
-- Lattice relaxation parameter
omega = 1.0 / ( nu_lat/cs_lat^2.0 + 0.5  )
print('Relaxation param. =', omega)
print('-----------------------------------------------------------------------')
