-- Musubi configuration file. 
-- This is a LUA script.
if tonumber(os.getenv("readRestart")) == 1 then
  readRestart = true
  print('  Reading the restart')
else
  readRestart = false
  print('  Writing the restart')
end

-- Simulation name
simulation_name = 'channel'
mesh = 'mesh/'  -- Mesh information
-- Time step settings
tmax =  500  -- total iteration number
time = {useIterations = true,
        min = 1, max = tmax, interval = 1}

ebug = { debugMode = true, debugFiles = true,
          debugMesh = './debug/mesh_', debugStates = { 
  write = {
    folder    = './debug/',    -- the folder the restart files are written to
    interval  = 1,           -- dump restart file interval
    tmin      = 1,           -- first timestep to output
    tmax      = tmax+1       -- last timestep to output
    }
 }} 

-- Initial condition 
initial_condition = { pressure = 1.0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

-- Boundary conditions
boundary_condition = {  
{ label = 'inlet', 
  kind = 'inlet_ubb', 
  velocityX = 0.06, velocityY = 0.0, velocityZ = 0.0 }
,{ label = 'wall', kind = 'wall'} 
,{ label = 'outlet', 
  kind = 'outlet_pab', pressure = 1.
  }
}

fluid = { omega = 1.8, rho0 = 1.0 }
  identify = {
      label = 'mini-channel',
      kind = 'lbm', 
      layout = 'd3q19', relaxation='bgk'}

-- Output settings
utput = { active = true , -- VTU output activated?
  folder = './output/',     -- Output location
  vtu = true,             -- VTU output activated?
  ascii = false,          -- VTU output activated?
  time = {min = tmax, max = tmax, interval = tmax/50}
}

-- Tracking              
tracking = {
  -- velocity profile over the channel height
  -- In the Poisseuille flow, this should be parabolic and depend on the pressure drop
{ label = 'velocityProfile',
  variable = {'velocity'},
  shape= { kind = 'canoND', object={origin ={  0., -20., 0.}, vec = {  0.,40.,0.} } },
  time = { min = tmax, max = -1, interval = 1},
  format = 'asciiSpatial'
  },
{ label = 'pressureDrop',
  variable = {'pressure'}, 
  shape= { kind = 'canoND', object={origin ={-75., 0., 0.}, vec = {150.,0.,0.} } },
  time = { min = tmax, max = -1, interval = 1},
  format = 'asciiSpatial'
  },
{ label = 'probePress', 
  variable = {'pressure'}, 
  shape= { kind = 'canoND', object={origin ={0., 0., 0.} } },
  time = { min = 0, max = tmax, interval = 20},
  format = 'ascii'
  },
  }

if readRestart == true then
-- Restart settings
restart = {
  -- If this table is available it will write a restart file
  -- with the specified options.
  --read  = 'restart/channel_lastHeader.lua', -- the folder the restart files are written to
  read  = 'restart/channel_header_00000499.000E+00.lua', -- the folder the restart files are written to
  write = 'restart_read/', -- the folder the restart files are written to
  time = {min = tmax, max = tmax, interval = 1}
}
elseif readRestart == false then
-- Restart settings
restart = {
  -- If this table is available it will write a restart file
  -- with the specified options.
  write = 'restart/', -- the folder the restart files are written to
  time = {min = tmax-1, max = tmax-1, interval = 1}
}
end
