outputname = 'multiPeriodic'
outputpreview = true
folder = 'mesh/'

length=1.0
ebug = { debugMode = true, debugFiles = true}

-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- (deprecated - used only for spacer stuff right now)
-- will become default for stl refinement level once
-- it is not mandatory any more
minlevel=6
refine = minlevel+1
deltax=2.*length/(2^minlevel)

dxmax = 2.*length/(2^refine)
bounding_cube = {origin = {-length,-length,-length},
               length = 2.*length}
-- refinebox: three entries: origin, length and refinementlevel
refinebox = {
            {origin = {-length/4.0, -length/4.0, -length/4.0},
            length = {length/2.0, length/2.0, length/2.0},
            refinementlevel = refine
            },
--            { origin = {25.0, 25.0, 0.0},
--              length = {25.0, 25.0, 64.0},
--              refinementlevel = maxrefine+1
--            } 
            }               
-- seed: position of seed 
spatial_object = {
  { 
  attribute ={
    kind = 'seed',  -- kind is seed
  },
  geometry = {
    kind = 'canoND', ---canoND is nothing but line/point/plane/box
    object = {
      origin ={0.0,0.0,0.0},
      }
    }
  },
{
  attribute = {
    kind = 'periodic',
  },
  geometry = {
    kind = 'periodic',
    object = {  
      plane1 = {
        origin = {-length,-length,deltax+dxmax/2.0}, 
        vec =  {{2.*length,0.0,0.0},
                {0.0,2.*length,0.0}}
      }, ---plane1
      plane2 = {
        origin ={-length,-length,-dxmax},
        vec =  {{0.0,2.*length,0.0},
                {2.*length,0.0,0.0}}
        }
      } ---plane2
   }
 },
{
  attribute = {
    kind = 'periodic',
  },
  geometry = {
    kind = 'periodic',
    object = {  
      plane1 = {
        origin ={length,-length,-length},
        vec =  {{0.0,2.*length,0.0},                  
                {0.0,0.0,2.*length}}
      }, ---plane1
      plane2 = {
        origin ={-length,-length,-length},                
        vec = {{0.0,0.0,2.*length},                   
               {0.0,2.*length,0.0}}
        }---plane 2
      } 
   }
 },
{
  attribute = {
    kind = 'periodic',
  },
  geometry = {
    kind = 'periodic',
    object = {
      plane1 = {
        origin ={-length,length,-length},
         vec = {{0.0,0.0,2.*length},
                {2.*length,0.0,0.0}}
                },
      plane2 = {
        origin ={-length,-length,-length},
        vec = {{2.*length,0.0,0.0},
               {0.0,0.0,2.*length}}
      }
   } ---plane2
 }
}
}


 
  
















