outputname = 'multiPeriodic'
outputpreview = true
folder = 'mesh/'

length=1.0
ebug = { debugMode = true, debugFiles = true}

-- stl_files: for each stl file put a table into
-- this table of tables. Or just a string for
-- the filname, if the other two parameters should
-- get the default: boundary_type = 1, fileformat = 'binary'
-- refinementlevel is the level to which the stl shall be refined
-- it is mandatory

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
-- general refinement levels
-- minrefine: defines minimum refinement level of the entire domain
--
-- maxrefine: defines maximum refinement
-- gets overwritten from madatory STL levels
-- (deprecated - used only for spacer stuff right now)
-- will become default for stl refinement level once
-- it is not mandatory any more
minlevel=4
--mrefine = maxrefine+2
deltax=2.*length/(2^minlevel)
--use mininum dx to offset the periodic planes 
--so that periodic planes are aligned perfectly parallel to each other
mindeltax=2.*length/(2^minlevel)

bounding_cube = {origin = {-length,-length,-length},
               length = 2.*length}
-- refinebox: three entries: origin, length and refinementlevel
refinebox = {
            {origin = {-0.25, -0.25/2., -0.5},
            length = {0.5, 0.5/2., 1.0},
            refinementlevel = mrefine
            },
            {origin = {-0.25, -0.25, -0.5},
            length = {0.5, 0.5, 1.0},
            refinementlevel = minlevel+1
            } 
            }               
-- seed: position of seed 
spatial_object = {
  { 
  attribute ={
    kind = 'seed',  -- kind is seed
  },
  geometry = {
    kind = 'canoND', ---canoND is nothing but line/point/plane/box
    object = {
      origin ={0.,0.,deltax*0.5},
      }
    }
  },
{
  attribute = {
    kind = 'periodic',
  },
  geometry = {
    kind = 'periodic',
    object = {  
      plane1 = {
        origin = {-length,-length,deltax+mindeltax/2.}, 
        vec =  {{2.*length,0.0,0.0},
                {0.0,2.*length,0.0}}
      }, ---plane1
      plane2 = {
        origin ={-length,-length,-mindeltax},
        vec =  {{0.0,2.*length,0.0},
                {2.*length,0.0,0.0}}
        }
      } ---plane2
   }
 },
{
  attribute = {
    kind = 'periodic',
  },
  geometry = {
    kind = 'periodic',
    object = {  
      plane1 = {
        origin ={length,-length,-length},
        vec =  {{0.0,2.*length,0.0},                  
                {0.0,0.0,2.*length}}
      }, ---plane1
      plane2 = {
        origin ={-length,-length,-length},                
        vec = {{0.0,0.0,2.*length},                   
               {0.0,2.*length,0.0}}
        }---plane 2
      } 
   }
 },
{
  attribute = {
    kind = 'periodic',
  },
  geometry = {
    kind = 'periodic',
    object = {
      plane1 = {
        origin ={-length,length,-length},
         vec = {{0.0,0.0,2.*length},
                {2.*length,0.0,0.0}}
                },
      plane2 = {
        origin ={-length,-length,-length},
        vec = {{2.*length,0.0,0.0},
               {0.0,0.0,2.*length}}
      }
   } ---plane2
 }
}
}


            
