
----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                              
--------------------------------------------------------------------!!!   

comment = 'cube refined'
folder = 'mesh/'

level = 2
minlevel = level
refinement = 1
walls = false
length = 10.
dx= length/2^level
dxDash = dx*0.01
origin = {-5., -5., -5. }
size = {
  length, 
  length, 
  length 
}
boxStart = 0.25
boxRatio = 0.25
dash = 0.1
bounding_cube = {origin = origin, 
               length = size[1]}
-- refinebox: three entries: origin, length and refinementlevel
box2 = { 
         origin = origin,
           vec = {
             {length/2.-dxDash, 0., 0. },
             {0., length/1.-dxDash, 0. },
             {0., 0., length/1.-dxDash }}
       }
box1 = { 
         origin = { 
           origin[1]+(boxStart)*length+dash,
           origin[2]+(boxStart)*length+dash,
           origin[3]+(boxStart)*length+dash,
         },         
         vec = {
           {(boxRatio)*length-2.*dash, 0., 0.},
           {0.,(1*boxRatio)*length-2.*dash, 0.},
           {0.,0., (1*boxRatio)*length-2.*dash}}
       }

spatial_object = {
  {
    -- Defining a domain boundary
    attribute = { kind = 'refinement', 
                  label = 'refine', 
                  level = minlevel + refinement
    },
    geometry = { -- Example for a sphere definition
      kind = 'canoND',
      object = box1
    }},
    {
    -- Defining a seed to identify the part of the computational domain in
    -- the universe cube.
    attribute = { kind = 'seed' },
    geometry = { -- single point definition with a canoND object.
                 kind = 'canoND',
                 object = { origin = {0.1, 0.1, 0.25} }
               }
  }
}
if walls then
table.insert( spatial_object, 
  { -- Channel Walls
    attribute = { kind = 'boundary',
                  label = 'walls', 
                },
    geometry =  {
      kind = 'canoND',
      object = {
      {  -- x-
         origin = {origin[1], origin[2], origin[3]},
         vec = {{ 0., length,0.0},
              {0.0,0., size[3]}}
      },
      {  -- x+
         origin = {origin[1]+size[1], origin[2], origin[3]},
         vec = {{ 0., length,0.0},
              {0.0,0., size[3]}}
      },
      {  -- y-
         origin = {origin[1], origin[2], origin[3]},
         vec = {{ length,0.,0.0},
              {0.0,0., size[3]}}
      },
      {  -- y+
         origin = {origin[1], origin[2]+size[2], origin[3]},
         vec = {{ length,0.,0.0},
              {0.0,0., size[3]}}
      },
      {  -- z-
         origin = {origin[1], origin[2], origin[3]},
         vec = {{ length,0.,0.0},
              {0.0,size[2],0. }}
      },
      {  -- z+
         origin = {origin[1], origin[2], origin[3]+size[3]},
         vec = {{ length,0.,0.0},
              {0.0, size[2],0.}}
      },
    }
  }})

end
