----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


require "seeder"
-- Musubi configuration file. 
-- This is a LUA script.
folderRead = 'restart_read/'
folderWrite = 'restart/'
ontrol_routine = 'debug'
balance = 'none'

-- Local refinement settings
--interpolation_method = 'average'
interpolation_method = 'quadratic'
--comm_reduced = false
                     
ebug = {
--  verbosity = 100,
  debugMode = true, 
  debugFiles = true,
  checkSteps = true,
  debugDependencies = true,
  dumpDependencies = true,
  dumpState = true,
  dumpAuxLists = true,
--  dumpTreeIDs = true
  }

-- Simulation name
simulation_name = 'gaussian'
mesh = 'mesh/'-- Mesh information
-- Time step settigs
tmax           = 40
sim_control = {
  time_control = { max = {iter = tmax}, 
                   interval = {iter=1} 
  }
}  
io_buffer_size = 1

rho0 = 1.
cs2 = 1./3.
originX =  origin[1]+0.28*length
originY =  origin[2]+0.245*length
originZ =  origin[3]+0.30*length
halfwidth = length/8
amplitude = 0.01
--if model == 'lbm' then
p0 = rho0*cs2
--else --set ref pressure to 0 for lbm_incomp
--  p0 = 0
--end 

function ic_1Dgauss_pulse(x, y, z, t)
  return p0+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2)
end
function ic_2Dgauss_pulse(x, y, z, t)
  --return p0 +amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
  return p0 +amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2+( z - originZ )^2))
--  return p0
end
-- Initial condition 
initial_condition = { pressure  = ic_2Dgauss_pulse,
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

identify = {
  label = 'debug_restart',
  relaxation = 'bgk',
  layout = 'd3q19'
}  

fluid = { omega = 1.8, rho0 = 1.0 }

if walls then
boundary_condition = {  
{ label = 'walls', kind = 'wall'} 
}
end

-- Tracking              
 racking = {
--   { label = 'probe_density', 
--   variable = {'velocity','density'}, 
-- --  reduction = {'sum','average'}, 
--   folder = 'tracking/',
-- --  shape = {{object = 'line',line= { origin = {0.,0.,0.}, direction = {1.0,0.,0.}, segments = 300}}},
--   shape = {{object = 'point',point= {{0.,0.,0.}}}},
-- --  shape = {{object = 'all'}},
--   time_control = {min = 0, max = 10, interval = 1}, 
--   format = 'ascii' }
  { label = 'line', 
  variable = {'density', 'velocity'}, 
  folder = 'tracking/',
   shape = {{object = 'line', 
             plane = {pos = {.0,-5.0,-5.0} , vecA = {.0,10.0,0.}, 
                      vecB = {.0,.0,10.}, segments1 = 100,
                      segments2 = 100},
             line = { origin = {.0,-5.0,-2.5} , direction = {.0,10.0,0.}, 
                      segments = 100}}},
  time_control = {min = {iter=0}, max = {iter=10}, interval = {iter=1}}, 
  format = 'ascii' } 
  ,
  { label = 'hvs_plane', 
  variable = {'density', 'velocity'}, 
  folder = 'tracking/',
   shape = {{object = 'plane', 
             plane = {pos = {-5.0,-5.0,.0} , vecA = {.0,10.0,0.}, 
                      vecB = {10.0,.0,0.}, segments1 = 100,
                      segments2 = 100}}},
--   shape = {{object = 'line', 
--             line = { origin = {.0,-5.0,-2.5} , direction = {.0,10.0,0.}, 
--                      segments = 100}}},
  time_control = {min = {iter= 0}, max = {iter= 10}, interval = {iter= 1}}, 
  format = 'harvester' } 
  }


-- Read or write?
if os.getenv('mode') == 'read' then
  print ('   READ MODE ')
restart = { read = folderWrite..'gaussian_header_0.000E+00.lua',
            write = folderRead,
            time_control = { min = {iter= 0}, max = {iter= tmax}, interval= {iter = tmax/3}}}
elseif os.getenv('mode') == 'write' then
  print ('   WRITE MODE ')
restart = { 
            write = folderWrite,
            time_control = { min = {iter= 0}, max= {iter = tmax}, interval = {iter= tmax/3}}}
end

if walls then
  print("Walls")
 -- Boundary conditions
--scheme["boundary_condition"] = {  
-- { label = 'walls',
--    kind = 'wall' }
-- }

end

