-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'channel'
mesh = 'mesh/'  -- Mesh information
-- Time step settings
tmax =  5000  -- total iteration number
interval = tmax/10
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax}

ebug = { 
  verbosity    = 100,
  debugMode    = true, 
  debugFiles   = true,
  dumpTreeIDs  = true,
  dumpAuxLists = true,
  debugMesh    = './debug/mesh_', 
  debugStates  = { 
  write = {
    folder    = './debug/',    -- the folder the restart files are written to
    time = { useIterations = true,interval = 1, min = 1, max = tmax }
    }
 }} 

-- Initial condition 
initial_condition = { pressure = 1.0, 
                      velocityX = 0.0,
                      velocityY = 0.0,
                      velocityZ = 0.0 }

-- Boundary conditions
boundary_condition = {  
{ label = 'inlet', 
  kind = 'inlet_ubb', 
  velocityX = 0.06, velocityY = 0.0, velocityZ = 0.0 }
,{ label = 'wall', kind = 'wall'} 
,{ label = 'outlet', 
  kind = 'outlet_pab', pressure = 1.
  }
}

fluid = { omega = 1.8, rho0 = 1.0 }
  identify = {
      label = 'mini-channel',
      kind = 'lbm', 
      layout = 'd3q19', relaxation='bgk'}

-- Output settings
utput = { active = true , -- VTU output activated?
  folder = './output/',     -- Output location
  vtu = true,             -- VTU output activated?
  ascii = false,          -- VTU output activated?
  time = {min = tmax, max = tmax, interval = tmax/50}
}

-- Tracking              
tracking = {
  -- velocity profile over the channel height
  -- In the Poisseuille flow, this should be parabolic and depend on the pressure drop
{ label = 'velocityProfile',
  variable = {'velocity'},
  shape= { kind = 'canoND', object={origin ={  0., -20., 0.}, vec = {  0.,40.,0.} } },
  time = { min = tmax, max = -1, interval = 1},
  format = 'asciiSpatial'
  },
{ label = 'pressureDrop',
  variable = {'density'}, 
  shape= { kind = 'canoND', object={origin ={-75., 0., 0.}, vec = {150.,0.,0.} } },
  time = { min = tmax, max = -1, interval = 1},
  format = 'asciiSpatial'
  },
{ label = 'probePress', 
  variable = {'density'}, 
  shape= { kind = 'canoND', object={origin ={0., 0., 0.} } },
  time = { min = 0, max = tmax, interval = 1},
  folder = 'tracking/',
  format = 'ascii',
  condition = {threshold = 2.0e-5, operator = '<='} 
  },
  { label = 'convergence', 
  variable = {'density'}, 
  shape= { kind = 'canoND', object={origin ={0., 0., 0.} } },
  time = { min = 0, max = tmax, interval = tmax/1000},
  format = 'convergence',
  convergence = {norm = 'average', nvals = 100, 
  condition = {threshold = 2.0e-10, operator = '<='} }
  },
{ label = 'totalDens', 
  variable = {'density'}, 
  reduction = {'sum'}, 
  shape= { kind = 'all', object={origin ={0., 0., 0.} } },
  time = { min = 0, max = tmax, interval = interval},
  folder = 'tracking/',
  format = 'ascii'
  },
  }

-- Restart settings
restart_deactivated = {
  -- If this table is available it will write a restart file
  -- with the specified options.
  write = 'restart/', -- the folder the restart files are written to
  time = {min = tmax+1, max = tmax+1, interval = 1}
}
