----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


require 'common'
tracking_folder = "TRACKING_FOLDER"
tmax  =  1000 * ( 4.^(level - 6 ))

-- Re = U_aver * Ly / viscosity
Reynolds = 10
omega = 1.821
vis = ( 1.0 / omega - 0.5 ) / 3.0   -- viscosity
R = ly / 2

velMax = ( 2 * Reynolds / omega - Reynolds ) / 8 / R
D_slope = 8.0 * vis * velMax / ly / ly * 3 -- density drop slope
p0 = rho0*cs2
--dt = getdtFromOmega( { dx = dx, nu_p = vis_phy, omega = omega} )
--dt = Reynolds * dx * dx * vis
--physics = { dt = dt, rho0 = 1000}
--vel_phy = dx * velMax / dt
print("-- height  is "..ly)
print("-- velMax  is "..velMax)

-- Analytical solutions
function wssA(x, y, z, t)
  return vis * 2 * math.abs(y/dx) * velMax / R / R
end
function velA(x, y, z, t)
  return velMax * ( 1 - (y/dx)^2 / R^2 )
end
------------------------------------------------------------------------

simulation_name = 'channel_flow_high_order_wall'
ebug = {
  debugMode = true,
  debugFiles = true,
  dumpDependencies = false,
  verbosity = 1,
}
time = {useIterations = true,
        max = tmax, interval = tmax/10, min = 1}
estart = {
--read = 'restart/omega'..omega..'/'..simulation_name..'_lastHeader.lua' ,
  write = 'restart/',
  time = {  interval  = 1, min = tmax, max = tmax,}
}

fluid = { omega = omega, rho0 = 1.0 }
interpolation_method = 'linear'
initial_condition = { pressure = p0,
                      velocityX = velA,
                      velocityY = 0.0,
                      velocityZ = 0.0 }
identify = {label = 'wall_position',layout = 'd3q19'}

variable = {
  { name = 'spacetime', 
    ncomponents = 1, 
    vartype = 'st_fun',
    st_fun = velA},
  { name = 'diff_vel_spacetime', 
    ncomponents = 1, 
    vartype = 'operation',
    operation = {
      kind = 'difference',
      input_varname = {'vel_mag','spacetime'},
    }
  },
 }

boundary_condition = {
  { label = 'outlet',
    kind = 'outlet_expol',
    pressure = p0,
  },
  { label = 'inlet',
    kind = 'inlet_ubb',
    velocityX = {
      predefined = 'combined',
      transient= {
        predefined='smooth',
        min_factor=0.0, max_factor=velMax, from_time=0, to_time=tmax/4},
      spatial = {
        predefined='parabol',
        shape = { kind = 'canoND',
                  object = { origin = { -length/2+dx*1.5, -R*dx, dx/2},
                             vec = { 0.0, 2*R*dx, 0.0 }
                           }
                }
                } -- spatial table
                }, -- velocityX table
    velocityY = 0.0,
    velocityZ = 0.0,
    pressure = p0,
  },
  { label = 'top_wall',   kind = 'wall_linearInterpolation' },
  { label = 'bottom_wall',kind = 'wall_linearInterpolation' },
  --{ label = 'top_wall',   kind = 'wall'},
  --{ label = 'bottom_wall',kind = 'wall'},
} -- BC table

utput = { active = true,
  folder = './',
  vtu = true,
  time = {min = 0, max = tmax, interval = 100}
}

tracking = {
  { label = 'pressProbe',
    variable = {
      'pressure',
    },
    shape = { kind = 'canoND',
              object = {origin = { 0.0, 0., dx/2},
                        vec = { 0.0, 0., 0.0},
                        segments = {100} }
            },
    time = { min = 0, max = tmax, interval = 1},
    folder = './tracking/',
    format = 'ascii', },
  { label = 'velSpatial_'..ly,
    variable = {
      'vel_mag',
      'spacetime',
      'diff_vel_spacetime'
    },
    shape = { kind = 'canoND',
              object = {origin = { 0.0, -height/2-wall_shift, dx/2},
                        vec = { 0.0, ly*dx, 0.0},
                        segments = {100} }
            },
    time = { min = tmax, max = tmax, interval = 10 },
    folder = './tracking/',
    format = 'asciiSpatial', },
  { label = 'velL2norm_'..ly,
    variable = {
      'diff_vel_spacetime',
      'spacetime'
    },
    shape = { kind = 'canoND',
              object = {origin = { 0.0, -height/2-wall_shift, dx/2},
                        vec = { 0.0, ly*dx, 0.0},
                        segments = {100} }
            },
    time = { min = tmax, max = tmax, interval = 10 },
    reduction = {'l2norm', 'l2norm'},
    folder = './',
    format = 'asciiSpatial', }
} -- track table

