-- Use this file as template. Do not modify this file for running some testcases
smoothbounds = true
qVal = true
refinepatch = true

logging = {level=10}
height =  0.41
nHeight = 50
l_h = 2.5
nLength = nHeight*l_h
dx = height/nHeight
length = nLength*dx
nLength_bnd = nLength+2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

dx_eps = length_bnd/2^20
dx_half = dx*0.5
zpos = dx_half
minlevel = level
if ( refinepatch == true ) then
  refinelevel = minlevel + 1
else
  refinelevel = minlevel
end


folder = 'mesh/'--..subprefix
nodebug = { debugMode = true, debugMesh = 'debug/' }

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

spatial_object = {
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { dx, height*0.5, zpos },
        }
    }
  },

  {
    attribute = {
      kind = 'boundary',
      label = 'west'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'east'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx_eps,-dx/2.0,-dx/2.0},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'north',
      level = minlevel + 0,
      distance_refine = {
        radius = 0.05,
        level_offset=0
      }
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -dx/2,height+dx_eps,-dx/2 },
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'south',
      level = minlevel + 0,
      distance_refine = {
        radius = 0.05,
        level_offset=0
      }
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-dx_eps,-dx/2.0},
        vec = {{length+2*dx,0.0,0.0},
               {0.0,0.0,2.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'obst',
      calc_dist = qVal,
      level = minlevel + 1,
      distance_refine = {
        {
          radius = 0.05,
          level_offset=0
        },  
        {
          radius = 0.075,
          level_offset=-1
        },  
      }
    },
    geometry = {
      kind = 'stl',
      object = {filename = 'eclipse.stl'}
    },
    transformation = {
      translation = {0.4, 0.2, 0.0}
    }
  },
--  {
--    attribute = {
--      kind = 'refinement',
--      level = refinelevel
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {length/8,height/4,-dx/2.0},
--          vec = { {0.0,height/2,0.0} ,{length/4,0.0,0.0},{0,0.0,10*dx} },
--      }
--    }
--  },
--  {
--    attribute = {
--      kind = 'refinement',
--      level = refinelevel
--    },
--    geometry = {
--      kind = 'canoND',
--      object = {
--        origin = {1*length/2,-dx,-dx/2.0},
--          vec = { {0.0,height,0.0} ,{length/4,0.0,0.0},{0,0.0,10*dx} },
--      }
--    }
--  },
  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-dx_eps, -dx_eps, dx+dx_eps},
          vec = {{length+2*dx_eps,0.0,0.0},
               {0.0,height+2*dx_eps,0.0}}
        },  --- plane1
        plane2 = {
          origin = {-dx_eps,-dx_eps,-dx_eps},
          vec = {{0.0,height+2*dx_eps,0.0},
                 {length+2*dx_eps,0.0,0.0}}
        } --- plane2
      }
    }
  },
}


