require "common"

if referenceRun == false then
  require "refParams"
else
  function refFunction()
    return 0
  end
end
-- Musubi configuration file. 
-- This is a LUA script.

-- Simulation name
simulation_name = 'gaussPulse1d'
mesh = 'mesh/' -- Mesh information

nElems = 2^(maxLevel)
--print('maximum number of elements in COS'..nElems)
-- Time step settigs
tmax   = nIters
time = {useIterations = true,
        min = 1, max = tmax, interval = tmax/10}
ebug = {debugMode = true, debugFiles = true}

fluid = { omega = omega, rho0 = 1.0 }

originX = -0.3*length
originX2 = 10.05
originY = -0.5*length + 0.65*length
originZ = 00.0
halfwidth = 0.01
amplitude = 0.001
background = 1.0

radius_rot = 0.2
circulation = 0.1

function ic_1Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX )^2) --+amplitude*math.exp(-0.5/((halfwidth*1.0)^2)*( x - originX2 )^2)
end
function ic_1Dgauss_pulse2(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*( x - originX2 )^2)
end
function ic_2Dgauss_pulse(x, y, z)
  return background+amplitude*math.exp(-0.5/(halfwidth^2)*(( x - originX )^2+( y - originY )^2))
end
-- Initial condition 
initial_condition = { density = ic_1Dgauss_pulse, 
                      velocityX =0.0, --{ predefined = "crvpX", 
                               --    radius_rot = radius_rot,
                               --    circulation= circulation,
                               --    center = { 0.0, 0.0, 0.0 } },
                       velocityY =0.0, --{ predefined = "crvpY", 
                                   --radius_rot = radius_rot,
                                   --circulation= circulation,
                                   --center = { 0.0, 0.0, 0.0 } },
                      velocityZ = 0.0 }

identify = {label='square',layout='d2q9'}

-- Output settings
output = { active = false, -- VTK output activated?
  folder = './output/', --_l'..level..'/',     -- Output location
  --dumpGhosts = true,
  vtk = false,             -- VTK output activated?
  time = {min = 0, max = -1, interval = 1}
}

-- Tracking              
tracking = {{
  -- tracking object for getting the error in terms of the l2norm
  label = label..'_error_l'..level, 
  variable = { 
     {'density'}, 
     {name = 'spacetime', ncomponents = 1, spacetime = refFunction},
     {name = 'difference', ncomponents = 1, dep = {'density', 'spacetime'} }},
  reduction = {'l2norm','l2norm','l2norm' },
  --reduction = {operation = 'sum', variable = {'difference'}},
  shape = {kind = 'canoND', object = {origin ={-0.5,0.,0.}, vec = {1.0, 0.0, 0.0}, segments = 10*nElems } },
  time = {min = tmax, max = -1, interval = 1},
  format = 'ascii',
  folder = './tracking/'
 }, 
 {
  -- tracking object for the spatial representation of the pressure
  label = label..'_spatial_l'..level, 
  variable = { 
     {'density', 1 }, 
     {name = 'spacetime', ncomponents = 1, spacetime = refFunction},
     {name = 'difference', ncomponents = 1, dep = {'density', 'spacetime'} }},
  shape = {kind = 'canoND', object = {origin ={-0.5,0.,0.}, vec = {1.0, 0.0, 0.0}, segments = 10*nElems } },
  time = {min = tmax, max = -1, interval = 1},
  format = 'asciiSpatial',
  folder = './tracking/'
  }
}
