--level=${level}$
--refinementLevel=${refinementLevel}$
--interpolation_method=${interpolation_method}$

if os.getenv("LEVEL") == nil then
  level =  9  
--  print (" LEVEL: Taking local definition     "..level )
else
  level = tonumber(os.getenv("LEVEL"))
--  print (" LEVEL: Taking environment variable "..level )
end

if os.getenv("REFINEMENT") == nil then
  refinementLevel = 1
--  print (" REFINEMENT: Taking local definition     "..refinementLevel )
else
  refinementLevel = tonumber(os.getenv("REFINEMENT"))
--  print (" REFINEMENT: Taking environment variable "..refinementLevel )
end

if os.getenv("INTERPOLATION_METHOD") == nil then
  --interpolation_method = 'average'
  --interpolation_method = 'quadraticExtended'
  interpolation_method = 'linear'
--  print (" METHOD: Taking local definition     "..interpolation_method )
else
--  if os.getenv("INTERPOLATION_METHOD") == "singleLevel" then
--    interpolation_method = 'linear'
--  else
    interpolation_method = os.getenv("INTERPOLATION_METHOD")
--  end
--  print (" METHOD: Taking environment variable "..interpolation_method )
end
useObstacle=false
if os.getenv("OBSTACLE") == nil then
  print(' obs nil       ')
else
  if os.getenv("OBSTACLE") == "1" then
    useObstacle=true
  else 
  end
end
if useObstacle ==true then
--  print(' WITH OBSTACLE ')
end


idLabel = 'channel'
refSolutionLevel = 11
if useObstacle == true then
  refOmega = 1.96
  refLevel = 9
else
  refOmega = 1.9
  refLevel = 6
end
u_in = 0.02
-- geometry definition
height =  0.41
length = 5*height
radius = 0.05
--
heightElem_refLevel = 6
refDx = length/(2^refLevel)
refHeight = heightElem_refLevel*refDx
m = 2^(refLevel - level)
omega = 1./(1/m*(1/refOmega -0.5)+0.5)
maxLevel = level+refinementLevel
--height = refHeight
dx     = length/(2^level)
dxMin  = length/(2^maxLevel)
dxDash = 0.5*dxMin
viscLB = 1/3*(1/omega-1/2)
-- physical reference values
dxPhys = dx
lPhys = length  -- m
csPhys = 300    -- m/s
csLB = 1/math.sqrt(3)
--acoustic scaling with speeds of sound as reference
-- csPhys = csLB * dxPhys / dtPhys
dtPhys = csLB/csPhys*dxPhys
rho0 = 1  -- kg/m^3
viscPhys = viscLB*dxPhys^2/dtPhys


nElemsMax = 2^maxLevel
if refinementLevel == 0 and level == refSolutionLevel then
  label = 'reference'
  referenceRun = true
  --print (" ============================================== " )
  --print (" ===        Reference RUN                   === " )
  --print (" ============================================== " )
else
  if refinementLevel == 0 then
    label = 'singleLevel'
  else
    label = 'RM_'..interpolation_method
  end
  referenceRun = false
end

if useObstacle == true then
  nIters = nElemsMax*100
else
  nIters = nElemsMax*400
end



print ("Reference Level   " .. refLevel)
print ("Reference omega   " .. refOmega)
--print ("Coarsening Factor " .. m)
print ("Current level     " .. level)
print ("Current omega     " .. omega)
--print ("Channel height    " .. refHeight)
--print ("        height    " .. height)
--print ("----------------  ")
--print ("Physical units    ")
--print ("Reference length  m  " .. lPhys )
--print ("Reference vel     m/s".. csPhys )
print ("Spatial step size m  dxPhys" .. dxPhys)
print ("   Time step size s  dtPhys" .. dtPhys)
print ("phys viscosity m^2/s " .. viscPhys)
--if level < refLevel then
--  error(' level is smaller than reference level'..refLevel )
--end

-- write dx and dt to file
-- summary file which collects analysed results for all levels
-- SUMMARY is a set up in evaluate.sh
fout = io.open( 'params_l'..level, 'a+' )

-- output the relative error to summary file
-- maxlevel is read from common.lua
-- print( "The error of level "..maxlevel.." is ",  err)
fout:write( dxPhys, "   ", dtPhys, "   \n")
io.close( fout )
