----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!
-- Musubi configuration file. 
require "common"
tracking_fol = 'tracking/'
restart_fol = 'restart/'

-- Simulation name
simulation_name = 'poisson'
mesh = 'mesh/' -- Mesh information
printRuntimeInfo = false

scaling = 'diffusive'
control_routine = 'fast'
io_buffer_size = 10 -- default is 80 MB
logging = {level=5}

tmax_p = 0.005 --sec
-- Time step settigs
sim_control = {
  time_control = { 
    max = tmax_p,
    interval = tmax_p/100
  } -- time control
 ,abort_criteria = {
    stop_file = './stop',
    steady_state = false,
    convergence = {
      variable = {'potential_phy'}, 
      shape = {
        kind = 'canoND',
        object = {origin = {rad_outer/2.0,0.0,0.0}}
      },
      time_control = {min = 0, max = tmax_p, interval = {iter=10}},
      reduction = 'average',
      norm='average', nvals = 50, absolute = true,
      condition = { threshold = 1.e-15, operator = '<=' }
    }
  }
} -- simulation control

-- restart 
NOrestart = {
  NOread = restart_fol..'poisson_lastHeader.lua',
  write = restart_fol,
 }

-- needed to dump variable in physical unit
physics = { dt = dt, rho0=1000.0, temp0=273.0 }

poisson = { 
  potential_diffusivity = 0.167, 
  permittivity=permit, 
  poisson_boltzmann = {
    moleDens0 = moleDens0,
    temp = temp, 
    valence={1.0,-1.0}, 
  }  
}

-- Initial condition 
initial_condition = { potential = ref_pot }

boundary_condition = {
  { 
    label = 'inner',
    kind = 'potential_dirichlet',
    curved = true,
    potential = pot_inner,
  },  
  { 
    label = 'outer',
    kind = 'potential_dirichlet',
    curved = true,
    potential = pot_outer
  },  
  { 
    label = 'z_wall',
    kind = 'wall',
  },  
}

identify = {
  layout='d2q9',
  kind='poisson', 
  relaxation = 'bgk'
}

glob_source = {
  charge_density = Q 
}
variable = {
  {
    name = 'analy_pot',
    ncomponents = 1,
    vartype = 'st_fun',
    st_fun = analy_pot
  },
}

-- Tracking
tracking = {
--  {
--    label = 'line', 
--    folder = tracking_fol,
--    variable = {'potential_phy','analy_pot'}, 
--    shape = {
--      kind = 'canoND', 
--      object = {
--        origin ={0.0,0.0,0.0},
--        vec = {dia_outer,0.0,0.0},
--        segments = dia_outer/dx
--      }
--    },
--    time_control = {min = {iter=0}, max = tmax_p, interval = 0.1/100},
--    output={format = 'asciiSpatial'}
--  },
--  {
--    label = 'vtk', 
--    folder = tracking_fol,
--    variable = {'potential_phy','analy_pot'}, 
--    shape = {
--      kind = 'all', 
--    },
--    time_control = {min = {iter=0}, max = tmax_p, interval = 0.1/25},
--    output={format = 'vtk'}
--  },

  {
    label = 'probe', 
    folder = tracking_fol,
    variable = {'potential_phy'}, 
    shape = {
      kind = 'canoND', 
      object = {
        origin ={rad_outer/2,0.0,0.0},
      }  
    },
    time_control = {min = {iter=0}, max = tmax_p, interval = {iter=25}},
    output={format = 'ascii'}
  },

}

