import math
import glob
import numpy as np
from itertools import *

sdr_path = $!seeder_path!$
mus_path = $!musubi_path!$
nHeight = $!seeder_nHeight!$
outletBCs = $!musubi_outletBC!$
names = ['expol', 'nrbc']

mus_path_expol = []
mus_path_nrbc = []
for ipath in range(len(mus_path)):
#    print('ipath = ', ipath)
    if 'expol' in mus_path[ipath]:
        mus_path_expol.append(mus_path[ipath])
    elif 'nrbc' in mus_path[ipath]:
        mus_path_nrbc.append(mus_path[ipath])

show_plot = True
markers = ['k-','r-','y-','g-','k-d','k-p']
plot  = []
font_size = 12
#figsize=[5,4]
set_majorgrid = True
font_family = 'serif'
font_type = 'Times New Roman'

for ioutlet in range(len(outletBCs)):
        if 'expol' in outletBCs[ioutlet]:
            mus_path = mus_path_expol
            outletBC = outletBCs[ioutlet]
        elif 'nrbc' in outletBCs[ioutlet]:
            mus_path = mus_path_nrbc
            outletBC = outletBCs[ioutlet]
   
   ### here begin the plots

     ## velocity y profile using y coord and vel_mag_phy
         
        # all together in one plot:
        for iplot in range(len(mus_path)):
            stplot = False
            eplot = False
            if iplot == 0:
                stplot = True
            plot.append(dict(kind = 'xy',
                data=[mus_path[iplot]+'/tracking/*vel_over_height*.res'],
                col=[2,4], dtype='float', label=str(nHeight[iplot]),
                startplot = stplot, endplot = eplot,
                ls=markers[iplot],
                ))
        eplot = True
        plot.append(dict(kind = 'xy',
                 data=[mus_path[iplot]+'/tracking/*vel_over_height*.res'],
                 col=[2,5], dtype='float', label='analytical solution ("simple")',
                 startplot = False, endplot = eplot,
                 xlabel = 'y coordinate [m]',
                 ylabel = 'velocity magnitude [m/s]',
                 title = 'velocity profile over channel height for outlet\_'+str(names[ioutlet]),
                 ls=markers[iplot+1],legend =dict(loc=8), format = 'png',
                 figname = 'vel_line_y_'+str(names[ioutlet]), dpi = 100))
        
        # separated in different plots for different nHeight:        
        
        for iplot in range(len(mus_path)):
                plot.append(dict(kind = 'xy',
                         data=[mus_path[iplot]+'/tracking/*vel_over_height*.res'],
                         col=[2,4], dtype='float', label=str(nHeight[iplot]),
                         startplot = True, endplot = True,
                         xlabel = 'y coordinate [m]',
                         ylabel = 'velocity magnitude [m/s]',
                         title = 'velocity profile over channel height for outlet\_'+str(names[ioutlet]),
                         ls=markers[iplot],legend =dict(loc=1), format = 'png',
                         figname = 'vel_line_y_'+str(nHeight[iplot])+'_'+str(names[ioutlet]), dpi = 100))
 
        ## velocity along the channel length at center line:                
        
        # all together in one plot:
        for iplot in range(len(mus_path)):
            stplot = False
            eplot = False
            if iplot == 0:
                stplot = True
            if iplot == len(mus_path)-1:
                eplot = True
            if iplot != len(mus_path)-1:
        
                 plot.append(dict(kind = 'xy',
                     data=[mus_path[iplot]+'/tracking/*vel_centerline*.res'],
                     col=[1,4], dtype='float', label=str(nHeight[iplot]),
                     startplot = stplot, endplot = eplot,
                     ls=markers[iplot],
                     ))
            else:
                plot.append(dict(kind = 'xy',
                         data=[mus_path[iplot]+'/tracking/*vel_centerline*.res'],
                         col=[1,4], dtype='float', label=str(nHeight[iplot]),
                         startplot = stplot, endplot = eplot,
                         xlabel = 'x coordinate [m]',
                         ylabel = 'velocity magnitude [m/s]',
                         title = 'velocity over channel length for outlet\_'+str(names[ioutlet]),
                         ls=markers[iplot],legend =dict(loc=1), format = 'png',
                         figname = 'vel_center_x_'+str(names[ioutlet]), dpi = 100))
        
        # separated in different plots for different nHeight:        
        
        for iplot in range(len(mus_path)):
                plot.append(dict(kind = 'xy',
                         data=[mus_path[iplot]+'/tracking/*vel_centerline*.res'],
                         col=[1,4], dtype='float', label=str(nHeight[iplot]),
                         startplot = True, endplot = True,
                         xlabel = 'x coordinate [m]',
                         ylabel = 'velocity magnitude [m/s]',
                         title = 'velocity over channel length for outlet\_'+str(names[ioutlet]),
                         ls=markers[iplot],legend =dict(loc=1), format = 'png',
                         figname = 'vel_center_x_'+str(nHeight[iplot])+'_'+str(names[ioutlet]), dpi = 100))
       
       
        ## pressure along the channel length at center line:                
        
        # all together in one plot:
        for iplot in range(len(mus_path)):
            stplot = False
            eplot = False
            if iplot == 0:
                stplot = True
            if iplot == len(mus_path)-1:
                eplot = True
            if iplot != len(mus_path)-1:
        
                 plot.append(dict(kind = 'xy',
                     data=[mus_path[iplot]+'/tracking/*press_line*.res'],
                     col=[1,4], dtype='float', label=str(nHeight[iplot]),
                     startplot = stplot, endplot = eplot,
                     ls=markers[iplot],
                     ))
            else:
                plot.append(dict(kind = 'xy',
                         data=[mus_path[iplot]+'/tracking/*press_line*.res'],
                         col=[1,4], dtype='float', label=str(nHeight[iplot]),
                         startplot = stplot, endplot = eplot,
                         xlabel = 'x coordinate [m]',
                         ylabel = 'pressure\_phy [m/s]',
                         title = 'pressure\_phy over channel length for outlet\_'+str(names[ioutlet]),
                         ls=markers[iplot],legend =dict(loc=1), format = 'png',
                         figname = 'press_center_'+str(names[ioutlet]), dpi = 100))
        
        # separated in different plots for different nHeight:        
        
        for iplot in range(len(mus_path)):
                plot.append(dict(kind = 'xy',
                         data=[mus_path[iplot]+'/tracking/*vel_centerline*.res'],
                         col=[1,4], dtype='float', label=str(nHeight[iplot]),
                         startplot = True, endplot = True,
                         xlabel = 'x coordinate [m]',
                         ylabel = 'velocity magnitude [m/s]',
                         title = 'velocity over channel length for outlet\_'+str(names[ioutlet]),
                         ls=markers[iplot],legend =dict(loc=1), format = 'png',
                         figname = 'vel_center_x_'+str(nHeight[iplot])+'_'+str(names[ioutlet]), dpi = 100))
