set term postscript enhanced color font "Times-Roman,16"
set output "analyticNumericComparisonFixedPos.ps"

reset

unset key
set key left top


# the dimensions of the plot
bm = 0.15
lm = 0.12
rm = 0.95
gap = 0.03
size = 0.75

set xlabel 't'
set lmargin at screen lm
set rmargin at screen rm
set bmargin at screen bm
set tmargin at screen bm + size + 2*gap

# the size of the domain
length = 2.0 * pi

# the position we plot the solution for
xPos = 1.518436
yPos = 3.089233

# some physical parameters of the mixture
viscosity = 7.310818e+01

# define the analytic solution
analytic(t) = sin(2.0*pi*xPos/length) * cos(2*pi*yPos/length) * exp((-8.0)*pi*pi*viscosity*t/(length*length) )

set label 'velocity [m/s]' at screen 0.03, bm + 0.5 * (size + 2*gap) offset 0,-strlen("velocity [m/s]")/4.0 rotate by 90

set xrange [0:0.02]
set multiplot
plot analytic(x) w l title 'analytic', \
     'velocityTrackedMixture.dat' every 20 using 2:3 with points pt 6 title 'simulation'


set key right top
set lmargin at screen lm + size*0.5
set rmargin at screen rm - 0.1
set bmargin at screen bm + 0.1
set tmargin at screen bm + size + 2*gap - 0.5*size

set yrange [0:0.00035]
set ytics 0.0001
set xlabel ''
plot 'velocityTrackedMixture.dat' using ($2):($3-analytic($2)) with lines title 'error' lt 3

