load '../output_style.p'
set output "analyticNumericComparisonFixedPos.eps"

load '../multicomp_style.p'

# the parameters of the initial conditions (have a look at the paper for the parameters)
tau = 0.001
deltaRho1 = 0.001
deltaRho2 = 0.001
omega = 0.95*pi

# to normalize the plot to physical liquid-mixture paramters
refNumDens = 1/1000.0
refMeter = 1.0
refMolWeight = 1.0
refKilo = 1/1000.0
refResist = 1.0e-17
refDens = 1/1000.0
refSec = 1.0e-17

# the size of the domain
length = 2.0 * pi

# the spatial coordinate we plot the solution for.
pos1 = 3.036873

# some physical parameters of the species
molecularWeight1 = 18.01528e-3 # water
molecularWeight2 = 22.98977e-3 # sodium
molecularWeight3 = 35.4527e-3  # chloride
diffusivity = 1.31570699e+3 # water - soidum

set lmargin at screen lm
set rmargin at screen rm
set bmargin at screen bm
set tmargin at screen bm + size + gap

set xrange [0:0.02]
set yrange [0.032/refNumDens:0.046/refNumDens]

set xlabel 'time [10^17 s]'
set label 'concentration [mol/m^3]' at screen 0.03, bm + 0.5 * (size + gap) offset 0,-strlen("concentration [mol/m^3]")/4.0 rotate by 90

analyticPrediction1(t) = ( tau / molecularWeight2 ) * ( exp( (-1)*((2*pi/length)**2.0)*diffusivity*t) * sin((2*pi*pos1)/length + omega)+ deltaRho2 + 1 ) / refNumDens

set multiplot
plot analyticPrediction1(x) title "analytic" ls 4 , \
     'musubiRes/mix_point_p00000.res' using ($1):($3) every 500 with points pt pointtyperesult2 lw pointwidthresult2 lc pointcolorresult2 title 'musubi 3D', \
     'densityTrackedSpecies2.dat' using ($2):(($3/molecularWeight2)/refNumDens) every 580 with points pt pointtyperesult lw pointwidthresult lc pointcolorresult title 'matlab 2D'

set key right top
set lmargin at screen lmRL
set rmargin at screen rmRL
set bmargin at screen bmRL
set tmargin at screen tmRL

set yrange [-0.00005/refNumDens:+0.00005/refNumDens]
#set ytics 0.0001
set xlabel ''
plot 'musubiRes/mix_point_p00000.res' using ($1):(($3)-analyticPrediction1($1)) with lines title 'deviation' ls 5

