-- maximum refinement level
level = 8
-- all units are in physical units
-- length (m)
length = 8.59e-2 
-- molecular weights(kg/m^3)
m1_p = 2.0e-3
m2_p = 28.0e-3
m3_p = 44.0e-3

-- reference values
-- molecular weight
m_ref = 1.0e-3
-- mesh size (m)
dx = length/(2^level)
-- time size (s)
dt = 1.0e-3
-- reference diffusivity
d_ref = dx*dx/dt

-- dimensionless parameters
m1 = m1_p/m_ref
m2 = m2_p/m_ref
m3 = m3_p/m_ref

-- molecular weight ratio
-- according to asinari model, m_rsig = min_varsig(m_varsig)/m_sig
m_min = math.min(m1,m2,m3)
m_r1 = m_min/m1
m_r2 = m_min/m2
m_r3 = m_min/m3

b_11 = 0.5*10/((2/m1)^0.5)
b_22 = 0.5*10/((2/m2)^0.5)
b_33 = 0.5*10/((2/m3)^0.5)

-- diffusivity coeff
d_11 = 1.0/b_11
d_22 = 1.0/b_22
d_33 = 1.0/b_33

d_12 = 0.833e-4/d_ref
d_21 = d_12
d_13 = 0.68e-4/d_ref
d_31 = d_13
d_23 = 0.168e-4/d_ref  
d_32 = d_23

diff_coeff1 = { d_11, d_12, d_13 }
diff_coeff2 = { d_21, d_22, d_23 }
diff_coeff3 = { d_31, d_32, d_33 }

-- lua function to initialize density
shift = 0.05
delta = 0.05
pi = math.pi
function species1Per( x, y, z )
  return (shift+delta*(1.0+math.sin(2.0*pi*x/length)))
end
function species2Per( x, y, z )
  return (shift+delta*(1.0+math.cos(2.0*pi*x/length)))
end
function species3Per( x, y, z )
  return ( 1.0 - (2.0*(shift+delta)+delta*(math.sin(2.0*pi*x/length)+math.cos(2.0*pi*x/length))) )
end


function species1Noflux( x, y, z )
  return (0.5*(0.5+0.5*(math.tanh(10.0*(x/length-0.5)))))*3.0/m_r1
end

function species2Noflux( x, y, z )
  return 0.5*3.0/m_r2
end

function species3Noflux( x, y, z )
  return (1.0-(0.5*(0.5+0.5*(math.tanh(10.0*(x/length-0.5))))+0.5))*3.0/m_r3
end

-- boundary condition
bc = {   
--                          { kind = 'wall',
--                            label = 'east'},
--                          { kind = 'wall',
--                            label = 'west'},
}
