----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!




-- Use this file as template. Do not modify this file for running some testcases

-- Location to write the mesh in.
-- Note the trailing path seperator, needed, if all mesh files should be in a
-- directory. This directory has to exist before running Seeder in this case!
folder = 'mesh/'

-- Bounding cube: the root node of the octree, defining the complete universe,
-- from which all elements are derived by recursive bisection.
-- The origin is the corner from which on the cube is spanned with the given
-- length in each direction.
bounding_cube = {origin = {-75.0, -75.0, -75.0},
               length = 150.}


-- A minimum level, by which all parts in the computational domain should at
-- least be resolved with. Default is 0.
minlevel = 7

-- *********************** Table of spatial objects *********************** --
-- Each spatial object is defined by an attribute and some geometric entity
-- attached to this attribute. Attributes might be defined multiple times.
-- Attributes are described by a kind (boundary, seed or refinement), a level
-- and maybe further kind specific values, like a label for the boundary.
-- Geometric objects might by right now:
-- - canoND (point, line, plane or box)
-- - STL
spatial_object = {
  {
    attribute = {
      kind = 'boundary',
      label='wall'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/wall.stl'
      }
    }
  },
--  {
--    attribute = {
--      kind = 'refinement',
--      label='refbox1',
--      level = minlevel + 1,
--    },
--    geometry = {
--      kind   = 'canoND',
--      object = { 
--      origin = {-50.0, -10.0, -10.0},
--        vec = { 
--                {50.0, 0.0, 0.0},
--                {0.0, 20.0, 0.0},
--                {0.0, 0.0, 20.0},
--        }       
--      }
--    }
--  },
--  {
--    attribute = {
--      kind = 'refinement',
--      label='refbox2',
--      level = minlevel + 2,
--    },
--    geometry = {
--      kind   = 'canoND',
--      object = { 
--      origin = {-40.0, -8.0, -8.0},
--        vec = { 
--                {25.0, 0.0, 0.0},
--                {0.0, 16.0, 0.0},
--                {0.0, 0.0, 16.0},
--        }       
--      }
--    }
--  },
  {
    attribute = {
      kind = 'refinement',
      label='refbox3',
      level = minlevel + 1,
    },
    geometry = {
      kind   = 'canoND',
      object = { 
      origin = {-30.0, -6.0, -6.0},
        vec = { 
                {15.0, 0.0, 0.0},
                {0.0, 10.0, 0.0},
                {0.0, 0.0, 10.0},
        }       
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='inlet'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/inlet.stl'
      }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label='outlet'
    },
    geometry = {
      kind = 'stl',
      object = {
        filename = 'stl/outlet.stl'
      }
    }
  },
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {10.0,0.1,0.1}
      }
    }
  }
}  

