# Run Musubi with different number of processes and check the restart files
# for dynamic load balancing by using the checksum (md5sum)

# add path to exec if runninng locally. For recheck leave it to "EXEC".
executable=EXEC
# executable=~/apes/musubi/build/musubi

error_flag=0

restart_folder='restart/'
balance_folder='balance/'

# delete existing restart and balance folders
rm -rf  ${restart_folder} ${balance_folder}

string_r=''
string_b=''

#procs='1 2'
procs='1 2 3 4 5 6 7 8 '

# execute for all procs
for nprocs in $procs
do
  # generate restart and balance WRITE md5 sums
  mkdir -p ${restart_folder}
  mkdir -p ${balance_folder}
  export mode=write 
  mpirun -np ${nprocs} ${executable}
  error_flag=$?
  echo 'the result is' $error_flag
  if [ $error_flag -eq 0 ]; then
    echo " SUCCESS "
  else
      echo Return status: $error_flag
      exit $error_flag
  fi
  #file name to store md5sum output from restart write
  sumrestart=restart_${nprocs}.md5
  #file name to store md5sum output from balance write
  sumbalance=balance_${nprocs}.md5

  echo 'Storing restart write md5sum to ' $sumrestart
  md5sum ${restart_folder}dynamic_LB_5.400E+00.lsb | awk '{print $1}' > ${sumrestart}
  md5sum ${restart_folder}dynamic_LB_7.200E+00.lsb | awk '{print $1}' >>${sumrestart}
  echo 'Storing balance md5sum to' $sumbalance
  md5sum ${balance_folder}dynamic_LB*.lsb | awk '{print $1}' > ${sumbalance}
done

echo 'testing the difference between the restart and the balance of one up to eight proc'
for nprocs in $procs
do
  string_r="restart_${nprocs}.md5"
  string_b="balance_${nprocs}.md5"

  difference=`diff $string_r $string_b`
    if [ "X$difference" = "X" ]; then
      echo "No difference found. $(tput setaf 2)OK$(tput sgr0)"
    else
      echo "$(tput setaf 1)Error$(tput sgr0): Difference found between restart_${nprocs} and balance_${nprocs}:"
           # md5sum error
           error_flag=99
      echo ${difference}
    fi
done

echo "Done.        with errorflag" $error_flag
exit $error_flag
