-- Use this file as template. Do not modify this file for running some testcases

require "common"

folder = 'mesh/'--..subprefix
debug = {debugMode = true, debugFiles=true}
logging = {level=10}

-- boundingbox: two entries: origin and length in this
-- order, if no keys are used
bounding_cube = {origin = {-dx/1.,-dx/1.,-dx/1.},
               length = length_bnd}

minlevel = level

---- refinebox: three entries: origin, length and refinementlevel
--refinebox = {{origin = {-dx, -dx, -dx},
--            length = {length+4*dx, height+2*dx, 5.0*dx},
--            refinementlevel = level
--            }}               

spatial_object = {
  {
    attribute = {
      kind = 'seed',
    },
    geometry = {
      kind = 'canoND',
      object = {
         origin = { length*0.5, height*0.5, zpos+dx/4.0 }, vec={0.0,height,0.0} 
      }
    }
  }
,
  {
    attribute = {
      kind = 'boundary',
      label = 'cem'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = { -dx,height+dx_half,-dx },
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'aem_dilute'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx,-dx/2.,-dx},
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'aem_concentrate'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx,2*height+dx+dx/2.,-dx},
        vec = {{length+4*dx,0.0,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet_dilute'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx/2.0,-dx,-dx},
        vec = {{0.0,height+dx,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'outlet_concentrate'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {length+dx/2.0,height-dx_half,-dx},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'inlet_dilute'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/2.0,-dx,-dx},
        vec = {{0.0,height+dx,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },
  {
    attribute = {
      kind = 'boundary',
      label = 'inlet_concentrate'
    },
    geometry = {
      kind = 'canoND',
      object = {
        origin = {-dx/4.0,height-dx_half,-dx},
        vec = {{0.0,height+2*dx,0.0},
               {0.0,0.0,length+4.*dx}}
        }
    }
  },

  {
    attribute = {
      kind = 'periodic',
    },
    geometry = {
      kind = 'periodic',
      object = {
        plane1 = {
          origin = {-dx,-dx,dx+dx/2.0},
          vec = {{length+4*dx,0.0,0.0},
               {0.0,3*height+2*dx,0.0}}
        },
        plane2 = {
          origin = {-dx,-dx,-dx/2.0},
          vec = {{0.0,3*height+2*dx,0.0},
                 {length+4*dx,0.0,0.0}}
        }         
      }  
    }
  }
}


