----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"
scheme_kind = 'bgk'
scheme_kind = 'bgk_withthermodynfac'
tracking_fol = './'--tracking_'..scheme_kind..'/'

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name
simulation_name = 'multispecies'
mesh = 'mesh/'
--mesh = { predefined='cube', 
--         origin = {0.,0.,0.}, 
--         length = length, 
--         refinementLevel = level }

-- Interpolation method
-- average, copyfirst, linear, debug
interpolation_method = 'average'                   
scaling = 'diffusive'

logging = {level=10}
ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/10
sim_control = {
  time_control = {
    min = 0, 
    max = tmax_p, 
    interval = interval }
}
sim_control = {
  time_control = {
    min = {iter =0 },
     max = {iter = 10},
      interval = {iter = 1}
      }
}

-- scheme model for single fluid simulation
scheme = {
  identify = {
      label = 'mix',
      kind = 'multi-species_liquid', 
      relaxation = scheme_kind, 
      --relaxation = 'mrt', 
-- scheme layout
      layout = 'd3q19'
      --layout = 'd2q9'
  },

  physics = { rho0 = rho0_p, 
              dt = dt, 
              temp0 = 298.15,
              moleDens0 = 1000.0,
              molWeight0 = m_min },

  mixture = { rho0 = rho0_p, moleDens0 = 1000.0, 
              omega_diff = 2.0,
              theta_eq = 0.0,
              omega_kine = 2.0,
	      prop_file = 'H2O_NaCl.dat',
	      temp = 298.15,
              atm_press = 1.01325e5,
              initial_condition = { pressure = 0.0}
            },
  -- field which defines fluid or specie
  -- Single fluid simulation
  field = {{
      label = 'H2O'
-- species properties
     ,species = { molweight = mH2O, diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl } }
-- Initial condition
     ,initial_condition = { 
         density = molefrac_H2O,
         molefraction = molefrac_H2O,
         velocityX = 0.0,--TGV_velocityX,
         velocityY = 0.0,--TGV_velocityY,
         velocityZ = 0.0}
     }
   ,{
     label = 'Na'
    ,species = { molweight = mNa, diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl } }
    ,initial_condition = {
         density = molefrac_Na,
         molefraction = molefrac_Na,
         velocityX = 0.0,--TGV_velocityX,
         velocityY = 0.0,--TGV_velocityY,
         velocityZ = 0.0}
    }
   ,{
     label = 'Cl'
    ,species = { molweight = mCl, diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag } }
    ,initial_condition = {
         density = molefrac_Cl,
         molefraction = molefrac_Cl,
         velocityX = 0.0,--TGV_velocityX,
         velocityY = 0.0,--TGV_velocityY,
         velocityZ = 0.0}
    }
  }
  -- add initial condition to variable system
  ,add_variable = { name = 'initialMoleFrac', 
    ncomponents = 1, 
    initialMoleFrac = { 
      { kind = 'combined', spatial = molefrac_H2O },
      { kind = 'combined', spatial = molefrac_Na },
      { kind = 'combined', spatial = molefrac_Cl }
    }
  }  

, 
tracking = {
  {
   label = 'line', 
   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},
               {'density'},{'density_phy'},
               {'H2O_molefrac'},{'Na_molefrac'},{'Cl_molefrac'},{'molefrac'}},
   ariable = {{'density'},{'numDensity_phy'},{'molefrac'}},
   folder = tracking_fol,
   shape = {kind = 'canoND', object= {origin={0.0,dx/2.0,dx/2},
                                      vec={length,0.0,0.0},
                                      segments =nLength+2 }
           },
   format = 'asciiSpatial',
   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
  }
  ,
  {
   label = 'point', 
   variable = {{'H2O_numDensity_phy'},{'Na_numDensity_phy'},{'Cl_numDensity_phy'},{'numDensity_phy'},
               {'H2O_molefrac'},{'Na_molefrac'},{'Cl_molefrac'},{'molefrac'}},
   folder = tracking_fol,
   --shape = {kind = 'canoND', object= {origin={length/2.,length/2.0,dx}}},
   shape = {kind = 'canoND', object= {origin={length/4.,dx/2.,dx/2.}}},
   format = 'ascii',
   time_control = {min = 0, max = tmax_p, interval = dt*10}, 
  }
  }
}

estart ={
  --read = 'restart/',
  write= 'restart/',
  time_control = { min = tmax, max = tmax, inteval = tmax }
  }
