import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'

shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          un_exec = True,
                          run_command = '',
                          params = [['nLength',60]],
                          additional_params = dict(MESH='mesh/'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          un_exec = True,
                          run_command = 'mpirun -np 2',
                          params = [[ "phase_shift", 0, 1e-4, 1e-3 ],
                                    ["theta_eq", 0,0.5,1.0],
                                    ["relaxation","bgk"]],
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/gleaner/gleaner.py',
                          template = 'params_plot.template',
                          extension='py',
                          run_exec = True,
                          run_command = '',
                          epend = ['seeder','musubi'],
                          depend = ['musubi'],
                          run_last = True,
                          create_depend_path = True,
                          create_depend_params = True,
                          label = 'gleaner'))

