----------------------- PLEASE READ THIS ---------------------------!!!

-- This input file is set up to run for regression check
-- Please make sure you DO NOT MODIFY AND PUSH it to the repository
                                                                          
--------------------------------------------------------------------!!!


-- This is a sample Musubi configuration file in lua format
-- 
-- WARNING!!!
-- LEAVE THIS FILE UNCHANGED IN THE REPOSITORY
-- 
-- Thank you!
--
--

-- load lua variables from simParam.lua
require "common"

-- simulation paramters
io_buffer_size = 1
printRuntimeInfo = true

-- communication pattern
--isend_irecv_overlap gathered_type isend_irecv typed_isend_irecv
commpattern = 'isend_irecv'
-- Simulation name

simulation_name = 'TGV_MS'

mesh = 'mesh/'  -- Mesh information

scaling = 'diffusive'

ebug = {debugMode = true, debugFiles = true, verbose =  true, verboseLevel = 100}

-- Time step settings
interval = tmax_p/10
sim_control = {
  time_control = {
    max = tmax_p, interval = interval
  }
}  

physics = { rho0 = rho0, 
            dt = dt, 
            --molWeigh0 = m_min,
            moleDens0 = moleDens0}

-- scheme model for single fluid simulation
identify = {
    kind = 'multi-species_liquid', 
    relaxation = 'bgk', 
    --relaxation = 'mrt', 
-- scheme layout
    layout = 'd3q19'
    --layout = 'd2q9'
}

mixture = { rho0 = rho0, moleDens0 = moleDens0, 
            omega_diff = 2.0,
            --kine_shear_viscosity = nu_p,
            omega_kine = 2.0,
            theta_eq = 1,
            initial_condition = { pressure = TGV_kinematicPressure }
          }
-- field which defines fluid or specie
-- Single fluid simulation
field = {{
    label = 'H2O'
-- species properties
   ,species = { molweight = mH2O, diff_coeff = { diff_diag, diff_H2O_Na, diff_H2O_Cl } }
-- Initial condition
   ,initial_condition = { 
       mole_fraction = molefrac_H2O,
       velocityX = velX_H2O,
       velocityY = velY_H2O,
       velocityZ = 0.0}
   }
 ,{
   label = 'Na'
  ,species = { molweight = mNa, diff_coeff = { diff_H2O_Na, diff_diag, diff_Na_Cl } }
  ,initial_condition = {
       mole_fraction = molefrac_Na,
       velocityX = velX_Na,
       velocityY = velY_Na,
       velocityZ = 0.0}
  }
 ,{
   label = 'Cl'
  ,species = { molweight = mCl, diff_coeff = { diff_H2O_Cl, diff_Na_Cl, diff_diag } }
  ,initial_condition = {
       mole_fraction = molefrac_Cl,
       velocityX = velX_Cl,
       velocityY = velY_Cl,
       velocityZ = 0.0}
  }
}

tracking = {
  {
   label = 'pointVel', 
   variable = {'H2O_velocity_phy','Na_velocity_phy','Cl_velocity_phy','velocity_phy'},
   folder = './',
   shape = {kind = 'canoND', object= {origin={length/4,length/2.,dx/2.0}}},
   output={format = 'ascii'},
   time_control = {min = 0, max = tmax_p, interval = tmax_p/tmax}, 
  }
--  ,{
--   label = 'hvs', 
--   variable = {{'H2O_velocity_phy'},{'Na_velocity_phy'},{'Cl_velocity_phy'},{'velocity_phy'},
--               {'H2O_density_phy'},{'Na_density_phy'},{'Cl_density_phy'},{'density_phy'}},
--   folder = './tracking/',
--   shape = {kind = 'canoND', object= {origin={0.0,0.0,dx/2.},
--                                      vec={{length,0.0,0.0},{0.0,length,0.0}},
--                                      segments ={nLength+2, nLength+2} }
--           },
--   output={format = 'harvester'},
--   time_control = {min = 0, max = tmax_p, interval = tmax_p}, 
--  }
 }

estart = {
  ead = 'restart/',
  write = 'restart/',
  time_control = {min = 0, max = tmax_p, interval = tmax_p}
}
