import os
apesFolder = os.getenv('HOME')+'/apes/'
# Production directory - default production directory is 'prod'
# comment out if you don't want user defined production directory
prod_dir = 'prod'

shepherd_jobs = []

shepherd_jobs.append(dict(executable=apesFolder+'seeder/build/seeder',
                          template='seeder.template',
                          extension='lua',
                          un_exec = True,
                          run_command = '',
                          params = [['nHeight',50]],
                          additional_params = dict(MESH='mesh/'),
                          create_subdir = ['mesh'],
                          prefix = 'sdr',
                          label = 'seeder'))

shepherd_jobs.append(dict(executable=apesFolder+'musubi/build/musubi',
                          template='musubi.template',
                          extension='lua',
                          run_exec = True,
                          run_command = 'mpirun -np 4',
                          params = [[ "inletBC", "ubb" ],
                                    [ "outletBC", "expol"],
                                    [ "relaxation","mrt"]],
                          additional_params = dict(MESH='../mesh/'),
                          create_subdir = ['tracking','restart'],
                          prefix = 'mus',
                          depend = ['seeder'],
                          create_depend_path = True,
                          label = 'musubi'))

shepherd_jobs.append(dict(executable=apesFolder+'harvester/scripts/harvest_series.py',
                          template = 'params_hvs.template',
                          extension='py',
                          run_exec = True,
                          run_command = '',
                          input_option = '--config',
                          depend = ['musubi'],
                          create_dir = False,
                          label = 'harvester'))

