-- all units are in physical units
-- length (m)
-- mesh info
refinement_factor = 4
length = 2*math.pi
nLength = 30--refinement_factor*100
nWidth = 1
nDepth = 0
dx = length/nLength
nLength_bnd = nLength + 2
level = math.ceil(math.log(nLength_bnd)/math.log(2))
length_bnd = (2^level)*dx

-- simulation params
tmax_p = refinement_factor^2*1*0.002
tmax = refinement_factor^2*10*200
-- time step size 
dt = tmax_p/tmax

-- molecular weights(kg/mol)
mH2O = 18.01528e-3 -- H20
mNa = 22.98977e-3 -- Na
mCl = 35.4527e-3  -- Cl
m_min = math.min(mH2O,mNa,mCl)

-- diffusivities
-- diagonals are not important
-- largest diffusivities
--diff_diag = 1.0e-8
--diff_H2O_Na = 1.31570699e-9
--diff_H2O_Cl = 2.097388e-9
--diff_Na_Cl = 2.95407e-11

-- fake diffusivities
diff_diag = 1.0e-2
diff_H2O_Na = 1.31570699e+3
diff_H2O_Cl = 2.097388e+3
diff_Na_Cl = 2.95407e+2

-- density
rho0_p = 1000.0 -- kg/m^3
rho0 = 1.0

-- shear viscosity
--nu_p = 1e-6 --m^2/s
nu_p = 1e-6*1e12
-- two smallness parameters to avoid division by zero
deltaRho1 = 0.001
deltaRho2 = 0.001
deltaRho3 = 0.001

---------------------------------------
-- Initial condition for solvent mixture
---------------------------------------
-- small parameter to control the behavior of the dominating solvent
tau_2 = 0.001

-- phase shift of species 2 with respect to species 3
omega = 0.95*math.pi

function solventH2O(x,y,z)
  p1 = tau_2*(math.sin(2*math.pi*x/length + omega) + deltaRho2 + 1.0)
  p2 = tau_2*(math.sin(2*math.pi*x/length) + deltaRho3 + 1.0 )
  return 1.0 - p1 - p2
end

function solventNa(x,y,z)
  return tau_2*(math.sin(2*math.pi*x/length + omega) + deltaRho2 + 1.0)
end

function solventCl(x,y,z)
  return tau_2*(math.sin(2*math.pi*x/length) + deltaRho3 + 1.0 )
end



-- molefraction initial condition
molefrac_H2O = solventH2O--TGV_density
molefrac_Na = solventNa--TGV_density
molefrac_Cl = solventCl--TGV_density

-- boundary condition
bc = {   
--                          { kind = 'wall',
--                            label = 'east'},
--                          { kind = 'wall',
--                            label = 'west'},
}
